{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}
<div class="roja45-productrental-customer-bookings">
    <h4 class="page-heading bottom-indent">{l s='Your Rentals' mod='roja45productrental'}</h4>
    <p class="info-title">{l s='Here are the rentals you\'ve made since your account was created.' mod='roja45productrental'}</p>
    <div class="block-center" id="block_booking_history">
        {if $rentals && count($rentals)}
        <table id="order-list"
               class="table table-bordered footab"
               data-controller="{$controller|escape:'html':'UTF-8'}">
            <thead>
            <tr>
                <th class="first_item"></th>
                <th class="item">{l s='Reference' mod='roja45productrental'}</th>
                <th class="item">{l s='Received' mod='roja45productrental'}</th>
                <th class="item">{l s='Status' mod='roja45productrental'}</th>
                <th class="item">{l s='Total Price' mod='roja45productrental'}</th>
                <th class="item">{l s='Total Paid' mod='roja45productrental'}</th>
                <th data-sort-ignore="true">&nbsp;</th>
                <th data-sort-ignore="true"class="last_item">&nbsp;</th>
            </tr>
            </thead>
            <tbody>
            {foreach $rentals as $rental}
                <tr class="{if $rental@first}first_item{elseif $rental@last}last_item{else}item{/if} {if $rental@index % 2}alternate_item{/if}"
                    data-booking-reference="{$rental.rental->reference|escape:'html':'UTF-8'}">
                    <td>
                        {if $rental.payment_due}<a href="{$controller|escape:'htmlall':'UTF-8'}?view_rental_payments=1&id_roja45_product_rental={$rental.id_roja45_product_rental|escape:'htmlall':'UTF-8'}" title="{l s='Payment Due' mod='roja45productrental'}"><i class="icon-exclamation-circle" style="color: orange"></i></a>{/if}
                    </td>
                    <td class="history_link bold">
                        <a class="show-booking" href="#">
                            {$rental.reference|escape:'html':'UTF-8'}
                        </a>
                    </td>
                    <td data-value="" class="bold">
                        {$rental.date_add|escape:'html':'UTF-8'}
                    </td>
                    <td class="bold">
                        {$rental.status}
                    </td>
                    <td data-value="" class="bold">
                        {$rental.totals.total_to_pay_inc_formatted}
                    </td>
                    <td data-value="" class="bold">
                        {$rental.totals.total_paid_inc_formatted}
                    </td>
                    <td data-value="" class="history_date bold">
                        <a href="{$controller|escape:'htmlall':'UTF-8'}?view_customer_rental=1&id_roja45_product_rental={$rental.id_roja45_product_rental|escape:'htmlall':'UTF-8'}">
                            <span>{l s='View' mod='roja45productrental'}</span>
                        </a>
                    </td>
                    <td data-value="" class="history_date bold">
                        <a href="{$controller|escape:'htmlall':'UTF-8'}?view_rental_payments=1&id_roja45_product_rental={$rental.id_roja45_product_rental|escape:'htmlall':'UTF-8'}" class="pay-rental">
                            {l s='Payments' mod='roja45productrental'}</span>
                        </a>
                    </td>
                </tr>
            {/foreach}
            </tbody>
        </table>
        {literal}
            <script>
                $(document).ready(function() {
                    $('.expand-reservation').on('click', function(e) {
                        var key = $(this).closest('tr').attr('data-key');
                        e.preventDefault();
                        if ($(this).closest('tr').hasClass('open')) {
                            $(this).closest('tr').removeClass('open');
                            $(this).closest('tr').addClass('closed');
                            $(this).closest('table').find('.reservation-details-'+key).slideUp();
                        } else {
                            $(this).closest('tr').removeClass('closed');
                            $(this).closest('tr').addClass('open');
                            $(this).closest('table').find('.reservation-details-'+key).slideDown();
                        }
                    });
                });
            </script>
        {/literal}
        {/if}
    </div>
    <ul class="footer_links clearfix">
        <li>
            <a class="btn btn-default button button-small" href="{$my_account_url|escape:'htmlall':'UTF-8'}">
			<span>
				<i class="icon-chevron-left"></i>{l s='Back to your account' mod='roja45productrental'}
			</span>
            </a>
        </li>
        <li>
            <a class="btn btn-default button button-small" href="{$home_url|escape:'htmlall':'UTF-8'}">
                <span><i class="icon-chevron-left"></i>{l s='Home' mod='roja45productrental'}</span>
            </a>
        </li>
    </ul>
</div>