{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="roja45-productrental-customer-bookings">
    <h4 class="page-heading bottom-indent">{l s='Payments' mod='roja45productrental'}</h4>
    <div class="block-center" id="block_booking_history">
        {if $payments && count($payments)}
            <table id="order-list"
                   class="table table-bordered footab">
                <thead>
                    <tr>
                        <th class="item">{l s='Payment Due By' mod='roja45productrental'}</th>
                        <th class="item">{l s='Date Paid' mod='roja45productrental'}</th>
                        <th class="item">{l s='Total (exc.)' mod='roja45productrental'}</th>
                        <th data-sort-ignore="true" class="last_item">&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                {if isset($payments)}
                {foreach $payments as $payment}
                    <tr class="{if $payment@first}first_item{elseif $payment@last}last_item{else}item{/if} {if $payment@index % 2}alternate_item{/if}">
                        <td data-value="" class="bold">
                            {$payment.date_due|escape:'htmlall':'UTF-8'}
                        </td>
                        <td data-value="" class="bold">
                            {$payment.date_paid|escape:'htmlall':'UTF-8'}
                        </td>
                        <td data-value="" class="bold">
                            {$payment.total_formatted|escape:'htmlall':'UTF-8'}
                        </td>
                        {if $payment.payment_due && !$payment.paid}
                            <td data-value="" class="history_date bold">
                                <a href="{$controller|escape:'htmlall':'UTF-8'}?pay_customer_rental=1&id_roja45_product_rental={$id_roja45_product_rental|escape:'htmlall':'UTF-8'}&id_roja45_product_rental_payment={$payment.id_roja45_product_rental_payment}" class="pay-rental">
                                    <i class="icon-money"></i> <span>{l s='Pay' mod='roja45productrental'}</span>
                                </a>
                            </td>
                        {else}
                            <td data-value="" class="history_date bold">
                            </td>
                        {/if}
                    </tr>
                {/foreach}
                {/if}
                </tbody>
            </table>
        {/if}
    </div>
    <ul class="footer_links clearfix">
        <li>
            <a class="btn btn-default button button-small" href="{$my_rentals_url|escape:'htmlall':'UTF-8'}">
			<span>
				<i class="icon-chevron-left"></i>{l s='Back to your rentals' mod='roja45productrental'}
			</span>
            </a>
        </li>
        <li>
            <a class="btn btn-default button button-small" href="{$home_url|escape:'htmlall':'UTF-8'}">
                <span><i class="icon-chevron-left"></i>{l s='Home' mod='roja45productrental'}</span>
            </a>
        </li>
    </ul>
</div>
