{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="row" id="start_bookings" xmlns="http://www.w3.org/1999/html">
    <div class="col-lg-12">
        <form class="container-command-top-spacing" action="#" method="post">
            <input type="hidden" name="id_roja45_product_rental" value="{$id_roja45_product_rental|escape:"html":"UTF-8"}"/>
            <div class="panel">
                <div class="panel-heading" >
                    <i class="icon-bed"></i>
                    {l s='Rental Summary' mod='roja45productrental'}<span class="badge">{$rental->reference|escape:"html":"UTF-8"}</span>
                </div>
                {capture "TaxMethod"}
                    {if ($order->getTaxCalculationMethod() == $smarty.const.PS_TAX_EXC)}
                        {l s='tax excluded.' mod='roja45productrental'}
                    {else}
                        {l s='tax included.' mod='roja45productrental'}
                    {/if}
                {/capture}
                {if ($order->getTaxCalculationMethod() == $smarty.const.PS_TAX_EXC)}
                    <input type="hidden" name="TaxMethod" value="0">
                {else}
                    <input type="hidden" name="TaxMethod" value="1">
                {/if}
                <div class="row">
                    <div class="col-xs-6">
                        <div class="panel">
                            <div class="panel-heading">{l s='Customer Details' mod='roja45productrental'}</div>
                            <dl class="well list-detail">
                                <dt>{l s='Name' mod='roja45productrental'}</dt>
                                <dd>{$customer->firstname|escape:'htmlall':'UTF-8'}&nbsp;{$customer->lastname|escape:'htmlall':'UTF-8'}</dd>
                                <dt>{l s='Email' mod='roja45productrental'}</dt>
                                <dd class="text-muted">{$customer->email|escape:'htmlall':'UTF-8'}</dd>
                                <dt>{l s='Telephone' mod='roja45productrental'}</dt>
                                <dd>{$address->phone|escape:'htmlall':'UTF-8'}</dd>
                                <dt>{l s='Cell Phone' mod='roja45productrental'}</dt>
                                <dd>{$address->phone_mobile|escape:'htmlall':'UTF-8'}</dd>
                                <dt>{l s='Country of Residence' mod='roja45productrental'}</dt>
                                <dd>{$address->country|escape:'htmlall':'UTF-8'}</dd>
                            </dl>
                        </div>
                    </div>
                    <div class="col-xs-6">
                    </div>
                </div>
                {foreach $rental_products as $rental_product}
                <div class="row">
                    <div class="col-xs-6">
                        <div class="panel">
                            <div class="panel-heading">{l s='Product Details' mod='roja45productrental'}</div>
                            <dl class="well list-detail">
                                {if !empty($rental_product.rental_product->telephone_1)}<dt>{l s='Telephone' mod='roja45productrental'}</dt>
                                <dd>{$rental_product.rental_product->telephone_1|escape:'htmlall':'UTF-8'}</dd>{/if}
                                {if !empty($rental_product.rental_product->telephone_2)}<dt>{l s='Telephone 2' mod='roja45productrental'}</dt>
                                <dd>{$rental_product.rental_product->telephone_2|escape:'htmlall':'UTF-8'}</dd>{/if}
                                {if !empty($rental_product.rental_product->address)} <dt>{l s='Address' mod='roja45productrental'}</dt>
                                <dd>{$rental_product.rental_product->address|escape:'htmlall':'UTF-8'}</dd>{/if}
                                {if !empty($rental_product.rental_product->address_2)}<dt>{l s='Address 2' mod='roja45productrental'}</dt>
                                <dd>{$rental_product.rental_product->address_2|escape:'htmlall':'UTF-8'}</dd>{/if}
                                {if !empty($rental_product.rental_product->city)}<dt>{l s='City' mod='roja45productrental'}</dt>
                                <dd>{$rental_product.rental_product->city|escape:'htmlall':'UTF-8'}</dd>{/if}
                            </dl>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-12">
                        <div class="panel">
                            <div class="panel-heading">{l s='Rental Details' mod='roja45productrental'}</div>
                            <div class="row">
                                {foreach $rental_product.models as $model}
                                    <div class="col-xs-4">
                                        <div class="panel">
                                            <dl class="well list-detail">
                                                <dt>{l s='Rental Model' mod='roja45productrental'}</dt>
                                                <dd>{$model.details->name|escape:'htmlall':'UTF-8'}</dd>
                                                {foreach $model.rates as $rate}
                                                    <dt>{l s='Rate' mod='roja45productrental'}</dt>
                                                    {assign var=periods value=$rate.periods|@count}
                                                    <dd>{l s='%d %s for %d nights' sprintf=[$rate.qty, $rate.name, $periods] mod='roja45productrental'}</dd>
                                                {/foreach}
                                                <dt>{l s='Total' mod='roja45productrental'}</dt>
                                                <dd>{displayPrice price={toolsConvertPrice price=$model.total_with_tax}}</dd>
                                                <dt>{l s='Total Paid' mod='roja45productrental'}</dt>
                                                <dd>{displayPrice price={toolsConvertPrice price=$order->total_paid_real}}</dd>
                                            </dl>
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                </div>
                {/foreach}
            </div>
        </form>
    </div>
</div>