{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}



<section id="roja45_productrental_summary" class=" roja45_productrental_booking_details box">
    <div class="card-block">
        <div class="row">
            <div class="col-md-12">

                <div id="roja45_productrental_spaces_block" class="col-lg-12">
                    <h3 class="h1 card-title">Podsumowanie Twojego zamówienia</h3>
                    {foreach $rental_products as $rental_product}
                        {foreach $rental_product.models as $model}
                            <div class="row">
                                <div class="col-lg-12 roja45_productrental_space_block">
                                    <div class="roja45_productrental_rates_block col-xs-12">
                                        <div class="row">
                                            {foreach $model.rates as $rate}
                                                <div class="item box">
                                                    <h3 class="page-subheading">
                                                        {$rental_product.product->name|escape:'html':'UTF-8'} : {$model.model_name|escape:'html':'UTF-8'} [{$rate.name|escape:'html':'UTF-8'}]
                                                    </h3>
                                                    <h4 class="page-subheading">
                                                        {l s='Collection' mod='roja45productrental'}: {$model.collection_date|escape:'html':'UTF-8'} : {$model.collection_time|escape:'html':'UTF-8'}
                                                    </h4>
                                                    <h4 class="page-subheading">
                                                        {l s='Return' mod='roja45productrental'}: {$model.return_date|escape:'html':'UTF-8'} : {$model.return_time|escape:'html':'UTF-8'}
                                                    </h4>
                                                    <ul class="product-rental-rate-list">
                                                        {foreach $rate.periods as $period}
                                                            <li class="ajax-block-product-model-rate roja45_productrental_rate_block"
                                                                data-id-roja45-product-rental-rate="{$period.id_roja45_product_rental_rate|escape:'htmlall':'UTF-8'}"
                                                                data-id-roja45-product-rental-model="{$period.id_roja45_product_rental_model|escape:'htmlall':'UTF-8'}">
                                                                <div class="heading">
                                                                    {$period.period_formatted|escape:'htmlall':'UTF-8'}
                                                                </div>
                                                                <div class="content">
                                                                    <table class="table table-responsive">
                                                                        <tr class="table-responsive-row">
                                                                            <th>{if ($period.period_name|count_characters>0)}{if isset($period.period_name)}{$period.period_name|escape:'html':'UTF-8'}{else}{l s='Seasonal Rate' mod='roja45productrental'}{/if}{else}{l s='Std Rate' mod='roja45productrental'}{/if}</th>
                                                                            <td></td>
                                                                        </tr>
                                                                        <tr class="table-responsive-row">
                                                                            <th>{l s='Rate' mod='roja45productrental'}</th>
                                                                            <td>{$period.value_formatted}</td>
                                                                        </tr>
                                                                        <tr class="table-responsive-row">
                                                                            <th class="align-content-lg-around">{l s='Discount' mod='roja45productrental'}</th>
                                                                            <td>{$period.discount_formatted}</td>
                                                                        </tr>
                                                                        <tr class="table-responsive-row">
                                                                            <th>{l s='Total' mod='roja45productrental'}</th>
                                                                            <td>{$period.total_formatted}</td>
                                                                        </tr>
                                                                        <tr class="table-responsive-row">
                                                                            <th>{l s='Qty' mod='roja45productrental'}</th>
                                                                            <td>{$period.entry}</td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                            </li>
                                                        {/foreach}
                                                    </ul>
                                                </div>
                                            {/foreach}
                                        </div>
                                    </div>
                                    <div class="roja45_productrental_block extras_block col-xs-12">
                                        <ul class="row list">
                                            {foreach $model.extras as $extra}
                                                <li class="ajax-block-product-model-extra product-rental-list col-xs-12">
                                                    <div class="row">
                                                        <div class="column col-xs-6 col-sm-6 col-md-3">
                                                            <div class="column-content row">
                                                                {if $extra@iteration==1}
                                                                    <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        {l s='Extra' mod='roja45productrental'}
                                                                    </div>
                                                                {/if}
                                                                <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                    <span>{$extra.name|escape:'html':'UTF-8'}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="column col-xs-6 col-sm-6 col-md-3">
                                                            <div class="column-content row">
                                                                {if $extra@iteration==1}
                                                                    <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        {l s='Charged' mod='roja45productrental'}
                                                                    </div>
                                                                {/if}
                                                                <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                    <span>{$extra.rate_name|escape:'html':'UTF-8'}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="column col-xs-6 col-sm-6 col-md-3">
                                                            <div class="column-content row">
                                                                {if $extra@iteration==1}
                                                                    <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        {l s='Cost' mod='roja45productrental'}
                                                                    </div>
                                                                {/if}
                                                                <div class="column-value column-value-{$rate@iteration|escape:'htmlall':'UTF-8'}">
                                                                    <span>{$extra.rate_formatted} (x {$extra.qty|escape:'html':'UTF-8'})</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="column col-xs-6 col-sm-6 col-md-3">
                                                            <div class="column-content row">
                                                                {if $extra@iteration==1}
                                                                    <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        {l s='Total' mod='roja45productrental'}
                                                                    </div>
                                                                {/if}
                                                                <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                    <span>{$extra.total_formatted}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            {/foreach}
                                        </ul>
                                    </div>
                                    <div class="roja45_productrental_block totals_block col-xs-12">
                                        <ul class="product-rental-list row list">
                                            <li class="ajax-block-product-model-total {if !isset($model.deposit)}last-item{/if} col-md-offset-6 col-xs-12 col-md-6">
                                                <div class="row">
                                                    <div class="total header col-xs-6">
                                                        {l s='Total' mod='roja45productrental'}&nbsp;{l s='(exc.)' mod='roja45productrental'}
                                                    </div>
                                                    <div class="total value col-xs-6">
                                                        {$model.total_formatted|escape:'html':'UTF-8'}
                                                    </div>
                                                </div>
                                            </li>
                                            {if isset($model.deposit)}
                                                <li class="ajax-block-product-model-total col-md-offset-6 col-xs-12 col-md-6">
                                                    <div class="row">
                                                        <div class="total header col-xs-6">
                                                            {l s='Payment Required' mod='roja45productrental'}
                                                        </div>
                                                        <div class="total value col-xs-6">
                                                            {$model.deposit|number_format:0|escape:'html':'UTF-8'}%
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="ajax-block-product-model-total last-item col-md-offset-6 col-xs-12 col-md-6">
                                                    <div class="row">
                                                        <div class="total header col-xs-6">
                                                            {l s='Total To Pay Now' mod='roja45productrental'}
                                                        </div>
                                                        <div class="total value col-xs-6">
                                                            {$model.total_to_pay_now_formatted|escape:'html':'UTF-8'}
                                                        </div>
                                                    </div>
                                                </li>
                                            {/if}
                                        </ul>
                                    </div> <!-- End roja45_productrental_nights_block -->
                                </div><!-- End roja45_productrental_space_block -->
                            </div>
                        {/foreach}
                    {/foreach}
                </div>
                <div class="roja45_productrental_product_block col-lg-12">
                    <div class="row">
                        <div class="col-md-offset-6 col-md-6 col-xs-12 roja45_productrental_totals_block">
                            <div class="row">
                                <table class="table table-bordered">
                                    <tfoot>
                                    <tr>
                                        <td class="text-right">{l s='Total Products' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(tax exc.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{$total_products_formatted}</td>
                                    </tr>
                                    {if $total_extras > 0}
                                        <tr>
                                            <td class="text-right">{l s='Total Extras' mod='roja45productrental'}
                                                <span class="tax-inc">{l s='(tax exc.)' mod='roja45productrental'}</span>
                                            </td>
                                            <td class="price">{$total_extras_formatted}</td>
                                        </tr>
                                    {/if}
                                    {if $total_products != total_to_pay}
                                        <tr>
                                            <td class="text-right">{l s='Subtotal' mod='roja45productrental'}
                                                <span class="tax-inc">{l s='(tax exc.)' mod='roja45productrental'}</span>
                                            </td>
                                            <td class="price">{$total_to_pay_formatted}</td>
                                        </tr>
                                    {/if}
                                    {if $taxes > 0}
                                        <tr>
                                            <td class="text-right">{l s='Taxes' mod='roja45productrental'}</td>
                                            <td class="price">{$taxes_formatted}</td>
                                        </tr>
                                    {/if}
                                    <tr>
                                        <td class="text-right">
                                            {l s='Total' mod='roja45productrental'}{if $display_without_tax} {l s='(tax exc.)' mod='roja45productrental'}{else}{l s='(tax inc.)' mod='roja45productrental'}{/if}
                                        </td>
                                        <td class="price">{if $display_without_tax}{$total_to_pay_formatted}{else}{$total_to_pay_inc_formatted}{/if}</td>
                                    </tr>
                                    {if ($total_damage_deposit > 0)}
                                        <tr>
                                            <td class="text-right">{l s='Damage Deposit' mod='roja45productrental'} {if $display_without_tax} {l s='(tax exc.)' mod='roja45productrental'}{else}{l s='(tax inc.)' mod='roja45productrental'}{/if}</td>
                                            <td class="price">{if $display_without_tax}{$total_damage_deposit_formatted}{else}{$total_damage_deposit_inc_formatted}{/if}</td>
                                        </tr>
                                    {/if}
                                    <tr>
                                        <td class="text-right total-to-pay-header">{l s='Total To Pay' mod='roja45productrental'} {if $display_without_tax}{l s='(tax exc.)' mod='roja45productrental'}{else}{l s='(tax inc.)' mod='roja45productrental'}{/if}</td>
                                        <td class="price total-to-pay">{if ($display_without_tax)}{$total_exc_formatted}{else}{$total_inc_formatted}{/if}</td>
                                    </tr>
                                    {if isset($total_deposit_to_pay) && total_deposit_to_pay > 0}
                                        <tr>
                                            <td class="text-right" colspan="2">
                                                <p class="roja45_productrental_notes">{l s='The required payment has been calculated and added to your cart, any remainder should be paid on collection.' mod='roja45productrental'}</p>
                                            </td>
                                        </tr>
                                    {/if}
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> <!-- End roja45_productrental_summary_block -->
