{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<script type="text/javascript">
    var roja45_rentals = JSON.parse('{$roja45_rentals|escape:'quotes':'UTF-8'}');
    var roja45_working_days = JSON.parse('{$roja45_working_days|escape:'quotes':'UTF-8'}');
    var roja45productrental_start_day = {$roja45productrental_start_day|escape:'quotes':'UTF-8'};
    var roja45_productrental_rateperiods = JSON.parse('{$roja45productrental_rateperiods|escape:'quotes':'UTF-8'}');
</script>

{if ($rental_product->enabled==1) && $rates_available}
    <div id="roja45productrental_block" class="form_wrapper_div roja45productrental_block">
        <input type="hidden" name="getAvailability" value="1">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_ID" value="{$ROJA45_PRODUCTRENTAL_ID|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATE_DURATION" value="{$ROJA45_PRODUCTRENTAL_RATE_DURATION|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_ID_PRODUCT" value="{$ROJA45_PRODUCTRENTAL_ID_PRODUCT|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE" value="{$id_product_attribute}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_MINIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MINIMUM_DURATION|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_QTY" value="{$product.minimal_quantity|escape:'htmlall':'UTF-8'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_CONTROLLER_URL" value="{$controller_url|escape:'htmlall':'UTF-8'}"/>

        <ul class="unorder_list_container">
            {if $rate_periods|@count==1}
            <li class="form-member select-field rate-periods" style="display:none;">
                <div class="view_wrapper">
                    <div class="paracolor">
                        <label class="view-select"">{l s='Rate Type' mod='roja45productrental'}</label>
                        <dl class="dropdown">
                            <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATEPERIOD" value="{$rate_periods[$default_id].id_rate_period|escape:'html':'UTF-8'}"/>
                            <dt class="fg-outlined current"><a href="#" class="selected" data-id="{$rate_periods[$default_id].id_rate_period|escape:'html':'UTF-8'}" data-value="{$rate_periods[$default_id].name|escape:'html':'UTF-8'}"><span>{$rate_periods[$default_id].name|escape:'html':'UTF-8'}</span></a></dt>
                        </dl>
                    </div>
                </div>
            </li>
            {else}
            <li class="form-member select-field rate-periods" style="display:none;">
                <div class="view_wrapper">
                    <div class="paracolor">
                        <label class="view-select"">{l s='Rate Type' mod='roja45productrental'}</label>
                        <dl class="dropdown">
                            <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATEPERIOD" value="{$rate_periods[$default_id].id_rate_period|escape:'html':'UTF-8'}"/>
                            <dt class="fg-outlined current"><a href="#" class="selected" data-id="{$rate_periods[$default_id].id_rate_period|escape:'html':'UTF-8'}" data-value="{$rate_periods[$default_id].name|escape:'html':'UTF-8'}"><span>{$rate_periods[$default_id].name|escape:'html':'UTF-8'}</span></a></dt>
                            <dd>
                                <ul>
                                {foreach $rate_periods as $rate_period}
                                    <li class="clearfix">
                                        <a href="#" data-id="{$rate_period.id_rate_period|escape:'html':'UTF-8'}" data-value="{$rate_period.name|escape:'html':'UTF-8'}"><span class="value">{$rate_period.name|escape:'html':'UTF-8'}</span></a>
                                    </li>
                                {/foreach}
                                </ul>
                            </dd>
                        </dl>
                    </div>
                </div>
            </li>
            {/if}
            <li class="form-member">
                <div class="view_wrapper cal cal-arrival">
                    <div class="paracolor">
                        <label class="view-select"">{l s='Collection Date' mod='roja45productrental'}</label>
                        <div class="fg-outlined current">
                            <input id="ROJA45_PRODUCTRENTAL_COLLECTION_DATE"
                                   name="ROJA45_PRODUCTRENTAL_COLLECTION_DATE"
                                   type="text"
                                   class="text datepicker"
                                   autocomplete="off"
                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"
                                   {if isset($ROJA45_PRODUCTRENTAL_COLLECTION_DATE)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_DATE|escape:'htmlall':'UTF-8'}"{/if}/>
                            <span class="input-group-addon">
                                <i class="icon-calendar"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </li>
            {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
            <li class="form-member">
                <div class="view_wrapper cal cal-arrival">
                    <div class="paracolor">
                        <label class="form-control-label" for="ROJA45_PRODUCTRENTAL_COLLECTION_TIME">{l s='Collection Time' mod='roja45productrental'}</label>
                        <div class="fg-outlined current">
                            <input id="ROJA45_PRODUCTRENTAL_COLLECTION_TIME"
                                   name="ROJA45_PRODUCTRENTAL_COLLECTION_TIME"
                                   type="text"
                                   class="text timepicker"
                                   autocomplete="off"
                                   placeholder="{$roja45_productrental_timeformat|escape:'html':'UTF-8'}"
                                   {if isset($ROJA45_PRODUCTRENTAL_COLLECTION_TIME)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                            <span class="input-group-addon"><i class="icon-clock-o"></i></span>
                        </div>
                    </div>
                </div>
            </li>
            {/if}
            <li class="form-member">
                <div class="view_wrapper cal cal-departure">
                    <div class="paracolor">
                        <label class="view-select"">{l s='Return Date' mod='roja45productrental'}</label>
                        <div class="fg-outlined current">
                            <input id="ROJA45_PRODUCTRENTAL_RETURN_DATE"
                                   name="ROJA45_PRODUCTRENTAL_RETURN_DATE"
                                   type="text"
                                   class="text input datepicker"
                                   autocomplete="off"
                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"
                                   {if isset($ROJA45_PRODUCTRENTAL_RETURN_DATE)}value="{$ROJA45_PRODUCTRENTAL_RETURN_DATE|escape:'htmlall':'UTF-8'}"{/if}/>
                            <span class="input-group-addon">
                                <i class="icon-calendar"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </li>
            {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
            <li class="form-member">
                <div class="view_wrapper cal cal-arrival">
                    <div class="paracolor">
                        <label class="form-control-label" for="ROJA45_PRODUCTRENTAL_RETURN_TIME">{l s='Return Time' mod='roja45productrental'}</label>
                        <div class="fg-outlined current">
                            <input id="ROJA45_PRODUCTRENTAL_RETURN_TIME"
                                   name="ROJA45_PRODUCTRENTAL_RETURN_TIME"
                                   type="text"
                                   class="text timepicker"
                                   autocomplete="off"
                                   placeholder="{$roja45_productrental_timeformat|escape:'html':'UTF-8'}"
                                   {if isset($ROJA45_PRODUCTRENTAL_RETURN_TIME)}value="{$ROJA45_PRODUCTRENTAL_RETURN_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                            <span class="input-group-addon"><i class="icon-clock-o"></i></span>
                        </div>
                    </div>
                </div>
            </li>
            {/if}
        </ul>

        <div id="roja45productrental_notes" class="roja45productrental_notes buttons_bottom_block no-print ">
            <ul class="">
                {if (($ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION>0) && ($ROJA45_PRODUCTRENTAL_MINIMUM_DURATION == $ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION))}
                    <li class="fixed-duration">
                        <p>
                            <span class="minimum-stay-text">{l s='%s day rental mandatory.' sprintf=[$ROJA45_PRODUCTRENTAL_MINIMUM_DURATION] mod='roja45productrental'}</span>
                        </p>
                    </li>
                {else}
                    <li class="minimum-duration" {if $ROJA45_PRODUCTRENTAL_MINIMUM_DURATION < 2}style="display:none;"{/if}>
                        <p>
                            <span class="minimum-stay-text">{l s='Minimum %s day rental' sprintf=[$ROJA45_PRODUCTRENTAL_MINIMUM_DURATION] mod='roja45productrental'}</span>
                        </p>
                    </li>
                    <li class="maximum-duration" {if $ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION == 0}style="display:none;"{/if}>
                        <p>
                            <span class="minimum-stay-text">{l s='Maximum %s day rental' sprintf=[$ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION] mod='roja45productrental'}</span>
                        </p>
                    </li>
                {/if}

            </ul>
            <div id="roja45productrental_message_block" style="display:none;">
            </div>
        </div>
        <div id="roja45productrental_getprice" class="buttons_bottom_block roja45productrental_getprice no-print ">
            <button type="submit" class="btn btn-default btn-productrental btn-availability no-print">
                <span>{l s='Get Rates' mod='roja45productrental'}</span>
            </button>
        </div>
        {if $roja45_productrental_showlivetotal>0}
            <div id="roja45productrental_liveprice" class="roja45productrental_liveprice buttons_bottom_block no-print" style="display:none;">
                <div class="waiting" style="display:none;">
                    <i class="icon-refresh icon-spin animated"></i>
                </div>
            </div>
            <div id="roja45productrental_liveprice_errors" class=" buttons_bottom_block no-print" style="display:none;">

            </div>
        {/if}
    </div>
{else}
    <div id="roja45productrental_block" class="">
        <div id="roja45productrental_no_rates" class="roja45productrental_no_rates buttons_bottom_block no-print ">
            <div id="roja45productrental_unavailable">
                <p>{l s='Sorry, this product is currently not available to rent online.' mod='roja45productrental'}</p>
                <p>{l s='Please call us to check availability' mod='roja45productrental'}</p>
            </div>
        </div>
    </div>
{/if}
{strip}
    {addJsDef roja45_productrental_controller=$controller_url|escape:'htmlall':'UTF-8'}
    {addJsDef roja45_productrental_dateformat=$roja45_productrental_dateformat|escape:'htmlall':'UTF-8'}

    {addJsDefL name=roja45_productrental_special_pricing}{l s='Your selected dates have special prices applied.  You can review the details after adding your rental to the  cart.' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_prices_from}{l s='From' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_arrival_date_error}{l s='Please provide the collection date.' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_departure_date_error}{l s='Please provide the return date.' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_closed}{l s='Store Closed' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_minduration}{l s='Date Unavailable' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_maxduration}{l s='Date Unavailable' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_available}{l s='Date Available' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_unavailable}{l s='Date Unavailable' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_checkin_only}{l s='Collection Only' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_checkout_only}{l s='Return Only' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_num_available}{l s='Available' mod='roja45productrental' js=1}{/addJsDefL}
    {addJsDefL name=roja45_productrental_calendar_tooltip_last}{l s='Last items available' mod='roja45productrental' js=1}{/addJsDefL}
{/strip}
