{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<h3 id="productrental_models_tab" class="idTabHrefShort page-product-heading">{l s='Models' mod='roja45productrental'}
    &nbsp;({$models|count|escape:'htmlall':'UTF-8'})</h3>

<div id="productrental-models-tab-content" class="productrental-models-tab-content tab-pane">
    <div class="block_content">
        <div id="roja45_productrental_producttab"
             class="roja45_productrental_producttab shopping-cart-footer product_column clearfix">
            {foreach $models as $model}
                <div class="roja45_productrental_model col-lg-12">
                    <div class="row">
                        {if $model.images}
                        <div class="roja45_productrental_model_images col-lg-4"
                             data-id-gallery="model-gallery-{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}">
                            <ul>
                                {foreach $model.images as $image}
                                {if $image@iteration < 6}
                                <li style="height: auto">
                                    <a rel="model-gallery-{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}"
                                       href="{$link->getImageLink($product->link_rewrite, $image.id_image, $thickboxSizeName)|escape:'htmlall':'UTF-8'}"
                                       class="fancybox" data-fancybox-group="other-views">
                                        <img id="{$image.id_image|escape:'htmlall':'UTF-8'}"
                                             class="img-responsive"
                                             alt="{$image.legend|escape:'htmlall':'UTF-8'}"
                                             title="{$image.legend|escape:'htmlall':'UTF-8'}"
                                             src="{$link->getImageLink($product->link_rewrite, $image.id_image,$smallSizeName)|escape:'htmlall':'UTF-8'}"
                                             width="{$smallSize.width|escape:'htmlall':'UTF-8'}px"
                                             height="{$smallSize.height|escape:'htmlall':'UTF-8'}px">
                                    </a>
                                </li>
                                {elseif ($image@iteration == 6)}
                                <li style="height: auto">
                                    <a rel="model-gallery-{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}"
                                       href="{$link->getImageLink($product->link_rewrite, $image.id_image, $thickboxSizeName)|escape:'htmlall':'UTF-8'}"
                                       class="fancybox" data-fancybox-group="other-views">
                                        <div class="last-image">
                                            <img id="{$image.id_image|escape:'htmlall':'UTF-8'}"
                                                 class="img-responsive more-images"
                                                 alt="{$image.legend|escape:'htmlall':'UTF-8'}"
                                                 title="{$image.legend|escape:'htmlall':'UTF-8'}"
                                                 src="{$link->getImageLink($product->link_rewrite, $image.id_image,$smallSizeName)|escape:'htmlall':'UTF-8'}"
                                                 width="{$smallSize.width|escape:'htmlall':'UTF-8'}px"
                                                 height="{$smallSize.height|escape:'htmlall':'UTF-8'}px">
                                            {if $model.images|@count gt 6}
                                                <div class="more-image-text">
                                                    <p>{l s='More Images' mod='roja45productrental'}</p>
                                                </div>
                                            {/if}
                                        </div>
                                    </a>
                                </li>
                                {else}
                                <li style="display: none">
                                    <a rel="model-gallery-{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}"
                                       href="{$link->getImageLink($product->link_rewrite, $image.id_image, $thickboxSizeName)|escape:'htmlall':'UTF-8'}"
                                       class="fancybox" data-fancybox-group="other-views">
                                        <img id="{$image.id_image|escape:'htmlall':'UTF-8'}"
                                             class="img-responsive"
                                             alt="{$image.legend|escape:'htmlall':'UTF-8'}"
                                             title="{$image.legend|escape:'htmlall':'UTF-8'}"
                                             src="{$link->getImageLink($product->link_rewrite, $image.id_image, $smallSizeName)|escape:'htmlall':'UTF-8'}"
                                             width="{$smallSize.width|escape:'htmlall':'UTF-8'}px"
                                             height="{$smallSize.height|escape:'htmlall':'UTF-8'}px">
                                    </a>
                                </li>
                                {/if}
                                {/foreach}
                            </ul>
                        </div>
                        {/if}
                        <div class="{if isset($model.images) && count($model.images)}col-lg-4{else}col-lg-6{/if}">
                            <div class="roja45_productrental_model_details row">
                                <h4>{$model.name|escape:'htmlall':'UTF-8'}</h4>
                                <p>{l s='Quantity Available: ' mod='roja45productrental'}{$model.qty_available|escape:'htmlall':'UTF-8'}</p>
                                {if isset($model.service_charge_type) && $model.service_charge_type>0}
                                    <p>
                                        <span>{l s='Daily Service Charge: ' mod='roja45productrental'}{displayPrice price=$model.service_charge}</span>
                                    </p>
                                {/if}
                                {if isset($model.minimum_rate_enabled) && $model.minimum_rate_enabled}
                                    <p>
                                        <span>{l s='Minimum Daily Rate: ' mod='roja45productrental'}{displayPrice price=$model.minimum_rate}</span>
                                    </p>
                                    <p>
                                        <span>{l s='This model has a minimum daily rate.  This rate will be applied if the daily total falls below this value.' mod='roja45productrental'}</span>
                                    </p>
                                {/if}
                            </div>
                        </div>
                        <div class="{if isset($model.images) && count($model.images)}col-lg-4{else}col-lg-6{/if}">
                            <div class="roja45_productrental_model_desc row">
                                <p>{$model.description|escape:'htmlall':'UTF-8'}</p>
                            </div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

{if $use_price_periods}
<h3 id="productrental_rates_tab" class="idTabHrefShort page-product-heading">{l s='Rates' mod='roja45productrental'}</h3>

<div id="productrental-rates-tab-content" class="productrental-rates-tab-content tab-pane">
    <div class="block_content">
        <div id="roja45_productrental_ratestab"
             class="roja45_productrental_ratestab shopping-cart-footer product_column clearfix">
            <div class="roja45_productrental_model">
                <div class="roja45_productrental_model_rates table-responsive">
                    {foreach $models as $model}
                    {if $use_price_periods==1}
                    <table class="table table-data-sheet">
                        {foreach $model.rates.rates as $rate}
                        {if $rate@iteration==1}
                        <thead>
                            <tr>
                                <th class="model-name">{$model.name|escape:'htmlall':'UTF-8'}</th>
                                {if !$model.rates.periods|count}
                                    <th class="standard-rate">
                                        <div class="rate-name">{l s='Low Season' mod='roja45productrental'}</div>
                                        <div class="rate-subtext">{l s='(Rest of year)' mod='roja45productrental'}</div>
                                    </th>
                                {else}
                                {foreach $model.rates.periods as $period}
                                    {if $period@iteration==1}
                                        <th class="standard-rate">
                                            <div class="rate-name">{$period.name|escape:'htmlall':'UTF-8'}</div>
                                            <div class="rate-subtext">{l s='(Rest of year)' mod='roja45productrental'}</div>
                                        </th>
                                    {else}
                                        <th class="special-rate">
                                            <div class="rate-name"
                                                 title="{$period.name|escape:'htmlall':'UTF-8'}">{$period.name|escape:'htmlall':'UTF-8'}</div>
                                            <div class="rate-subtext">({$period.desc|escape:'htmlall':'UTF-8'})</div>
                                        </th>
                                    {/if}
                                {/foreach}
                                {/if}
                            </tr>
                        </thead>
                        {/if}
                        <tbody class="">
                            <tr class="{cycle values="odd,even"}">
                                <td class="rate-heading"
                                    title="{$rate.standard.0.description|escape:'htmlall':'UTF-8'}">
                                    <div class="rate-name">{$rate.details->name|escape:'htmlall':'UTF-8'}</div>
                                    <span class="help-icon"><i class="fa fa-info-circle"></i></span>
                                </td>
                                <td>
                                    <div class="rate-value">{displayPrice price=$rate.standard.0.rate}</div>
                                    <div class="rate-type">{l s='(Daily)' mod='roja45productrental'}</div>
                                </td>
                                {if isset($rate.periods)}
                                    {foreach $rate.periods as $rate_period}
                                        <td>
                                            <div class="rate-value"
                                                 title="{$rate_period.description|escape:'html':'UTF-8'}">{displayPrice price=$rate_period.rate}</div>
                                            <div class="rate-type">{l s='(Per Night)' mod='roja45productrental'}</div>
                                        </td>
                                    {/foreach}
                                {/if}
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                    {else}

                    {/if}
                    {/foreach}
                </div>
            </div> <!-- End roja45_productrental_model -->
        </div> <!-- End roja45_productrental_ratestab -->
    </div> <!-- End block_content -->
</div>
{/if}

