{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{foreach $rental_products as $rental_product}
    <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
        <tr>
            <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:16px;color: #444444;text-transform:uppercase;line-height:20px;">{l s='Product' mod='roja45productrental'}</span>
            </td>
            <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:16px;color: #444444;text-transform:uppercase;line-height:20px;">{$rental_product.name|escape:'html':'UTF-8'}</span>
            </td>
        </tr>
        {if (isset($rental_product.product_address_block_html) || isset($rental_product.google_url))}
            <tr>
                <td style="width:100%;border:1px solid #D6D4D4;border-bottom: 0;background-color: #ffffff;padding: 5px;">
                    {if (isset($rental_product.product_address_block_html))}
                        <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:300;font-size:13px;color: #444444;">{$rental_product.product_address_block_html}</span>
                    {/if}

                    {if (isset($rental_product.url))}
                        <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:300;font-size:13px;color: #444444;"><a href="{$rental_product.url|escape:'html':'UTF-8'}">{l s='Web' mod='roja45productrental'}</a></span>
                    {/if}
                    {if (isset($rental_product.email))}
                        <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:300;font-size:13px;color: #444444;"><a href="{$rental_product.email|escape:'html':'UTF-8'}">{$rental_product.email|escape:'html':'UTF-8'}</a></span>
                    {/if}
                </td>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;min-height:25px;">
                    {if (isset($rental_product.google_url))}
                        <a href="{$rental_product.google_url}">
                            <img src="{$rental_product.google_static_image}"
                                 width="{$rental_product.image_width}"
                                 height="{$rental_product.image_height}"/>
                        </a>
                    {/if}
                </td>
            </tr>
        {/if}
        {if !empty($rental_product.telephone_1)}
        <tr>
            <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                <span style="color: #333;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{l s='Telephone #1' mod='roja45productrental'}</span>
            </td>
            <td class="amount text-right nowrap" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 10px;">
                <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:300;font-size:13px;color: #444444;">Telephone:&nbsp;{$rental_product.telephone_1|escape:'html':'UTF-8'}</span>
            </td>
        </tr>
        {/if}
        {if !empty($rental_product.telephone_2)}
            <tr>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                    <span style="color: #333;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{l s='Telephone #2' mod='roja45productrental'}</span>
                </td>
                <td class="amount text-right nowrap" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 10px;">
                    <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:300;font-size:13px;color: #444444;">Telephone 2:&nbsp;{$rental_product.telephone_2|escape:'html':'UTF-8'}</span>
                </td>
            </tr>
        {/if}
        {if !empty($rental_product.email)}
        <tr>
            <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                <span style="color: #333;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{l s='Email' mod='roja45productrental'}</span>
            </td>
            <td class="amount text-right nowrap" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 10px;">
                <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{$rental_product.email|escape:'htmlall':'UTF-8'}</span>
            </td>
        </tr>
        {/if}
    </table>
    <table class="table" bgcolor="#ffffff" style="width:100%">
        <tr>
            <td class="space" style="width:20px;padding:2px 0">&nbsp;</td>
        </tr>
    </table>

    {foreach $rental_product.models as $model}
        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
            <tr>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;min-height:25px;">
                    {if !empty($model.image_url)}
                        <img src="{$model.image_url|escape:'html':'UTF-8'}"
                             alt="{$model.model_name|escape:'html':'UTF-8'}"
                             title="{$model.model_name|escape:'html':'UTF-8'}">
                    {/if}
                </td>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                    <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:16px;color: #444444;text-transform:uppercase;line-height:20px;">{$model.model_name|escape:'html':'UTF-8'}</span>
                </td>
            </tr>
            <tr>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                    <span style="color: #333;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{l s='Collection' mod='roja45productrental'}</span>
                </td>
                <td class="amount text-right nowrap" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 10px;">
                    <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{$model.collection_date|escape:'html':'UTF-8'} : {$model.collection_time|escape:'html':'UTF-8'}</span>
                </td>
            </tr>
            <tr>
                <td class="text-right" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 10px;">
                    <span style="color: #333;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{l s='Return' mod='roja45productrental'}</span>
                </td>
                <td class="amount text-right nowrap" style="width:50%;border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 10px;">
                    <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 13px;">{$model.return_date|escape:'html':'UTF-8'} : {$model.return_time|escape:'html':'UTF-8'}</span>
                </td>
            </tr>
        </table>
        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
            <tr>
                <td class="space" style="width:20px;padding:2px 0">&nbsp;</td>
            </tr>
        </table>
        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
            <tr>
                <td class="text-right" style="width:100%;border:0px solid #D6D4D4;background-color: #fbfbfb;padding: 5px;">
                    <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:14px;color: #444444;text-transform:uppercase;">{l s='Requested Rates' mod='roja45productrental'}</span>
                </td>
            </tr>
        </table>
        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
            <tr>
                <td class="text-right">
                    {foreach $model.rates as $rate}
                        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
                            <tr>
                                <td class="text-right" style="width:50%;border-left:1px solid #D6D4D4;border-right:1px solid #D6D4D4;background-color: #fbfbfb;padding: 5px;">
                                    <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:13px;color: #444444;">{l s='Model #%s' sprintf=[{$rate@index|intval+1}] mod='roja45productrental'}</span>
                                </td>
                            </tr>
                        </table>
                        <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
                            <thead>
                            <tr>
                                <th class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                    <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;width:100%;padding: 10px;">Data</span>
                                </th>
                                <th class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                    <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;width:100%;padding: 10px;">Stawka podst.</span>
                                </th>
                                <th class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                    <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;width:100%;padding: 10px;">{l s='Discount' mod='roja45productrental'}</span>
                                </th>
                                <th class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                    <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;width:100%;padding: 10px;">{l s='Final Rate' mod='roja45productrental'}</span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            {foreach $rate.periods as $period}
                                <tr>
                                    <td align="left" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                        <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$period.period_formatted}</span>
                                    </td>
                                    <td align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                        <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$period.value_formatted|escape:'html':'UTF-8'}</span>
                                    </td>
                                    <td align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                        <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$period.discount_formatted|escape:'html':'UTF-8'}</span>
                                    </td>
                                    <td align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                        <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$period.total_formatted|escape:'html':'UTF-8'}</span>
                                    </td>
                                </tr>
                            {/foreach}
                            </tbody>
                        </table>
                        <table class="table" bgcolor="#ffffff" style="width:100%">
                            <tr>
                                <td class="space" style="width:20px;padding:7px 0">&nbsp;</td>
                            </tr>
                        </table>
                    {/foreach}
                </td>
            </tr>
        </table>

        {if ($model.extras|@count>0)}
            <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
                <tr>
                    <td class="text-right">
                        <div class="table-responsive">
                            <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
                                <tr>
                                    <td class="text-right" style="width:100%;border-left:1px solid #D6D4D4;border-right:1px solid #D6D4D4;background-color: #fbfbfb;padding: 5px;">
                                        <span class="title" style="font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-weight:500;font-size:13px;color: #444444;">Extras</span>
                                    </td>
                                </tr>
                            </table>
                            <table class="table table-recap" bgcolor="#ffffff" style="width:100%;border-collapse:collapse" cellSpacing=0 cellPadding=0 border=0>
                                <thead>
                                <tr>
                                    <th align="left" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                        <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{l s='Extra' mod='roja45productrental'}</span>
                                    </th>
                                    <th align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                        <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{l s='Charged' mod='roja45productrental'}</span>
                                    </th>
                                    <th align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                        <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{l s='Cost' mod='roja45productrental'}</span>
                                    </th>
                                    <th align="center" class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #fbfbfb;padding: 5px;">
                                        <span class="title_box" style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{l s='Total' mod='roja45productrental'}</span>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $model.extras as $extra}
                                    <tr>
                                        <td class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                            <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$extra.name}</span>
                                        </td>
                                        <td class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                            <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$extra.rate_name}</span>
                                        </td>
                                        <td class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                            <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$extra.rate_formatted}}</span>
                                        </td>
                                        <td class="amount text-right nowrap" style="border:0px solid #D6D4D4;border-bottom: 1px solid #d6d4d4;background-color: #ffffff;padding: 5px;">
                                            <span style="color: #444444;font-family: Helvetica, 'Open Sans', Arial, sans-serif;font-size: 12px;">{$extra.total_formatted}}</span>
                                        </td>
                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                        </div>
                    </td>
                </tr>
            </table>
        {/if}
    {/foreach}
{/foreach}
