{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div id="roja45_productrental_booking_details"
     class="roja45_productrental_booking_details shopping-cart-footer product_column clearfix">
    <h2>{l s='Rental Summary' mod='roja45productrental'}</h2>
    <div class="roja45_productrental_booking_details_container col-lg-12">
        <div class="row">
            <div class="roja45_productrental_product_block col-lg-12">
                <div class="row">
                    <div class="col-lg-2 col-xs-12 roja45_productrental_product_image">
                        <a href="{$product_link|escape:'html':'UTF-8'}">
                            <img src="{$image_url|escape:'html':'UTF-8'}"
                                 alt="{$product->name|escape:'html':'UTF-8'}"
                                 {if isset($mediumSize)}width="{$mediumSize.width|escape:'html':'UTF-8'}px"
                                 height="{$mediumSize.height|escape:'html':'UTF-8'}px" {/if} />
                        </a>
                    </div>
                    <div class="col-lg-5 col-xs-12 roja45_productrental_product_title">
                        <div class="row">
                            <h3>{$product->name|escape:'html':'UTF-8'}</h3>
                        </div>
                        <div class="row">
                            <div class="roja45_productrental_model_summary">
                                {foreach $models as $model}
                                    <ul class="model-summary-container">
                                        <li class="model-summary-item">
                                            <h4>{$model.details->name|escape:'html':'UTF-8'}</h4>
                                            {foreach $model.rates as $rate}
                                                <ul class="rate-summary-container">
                                                    <li class="rate-summary-item">
                                                        <table>
                                                            <tr data-id-product="{$product->id|escape:'html':'UTF-8'}" data-id-product-attribute="0" data-id-roja45-product-cart="{$id_roja45_product_cart|escape:'html':'UTF-8'}" data-id-roja45-product-model="{$k|escape:'html':'UTF-8'}">
                                                                <td>{$rate.name|escape:'html':'UTF-8'}</td>
                                                                <td>{displayPrice price={toolsConvertPrice price=$rate.total}}</td>
                                                                <td><a href="#" class="delete_cart_model"><i class="icon-2x icon-trash-o"></i><span class="label">{l s='Delete' mod='roja45productrental'}</span></a></td>
                                                            </tr>
                                                        </table>
                                                    </li>
                                                </ul>
                                            {/foreach}
                                        </li>
                                    </ul>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-xs-12 roja45_productrental_totals_block">
                        <div class="row">
                            <table class="table table-bordered">
                                <tfoot>
                                <tr>
                                    <td class="text-right">{l s='Total' mod='roja45productrental'}
                                        <span class="tax-ind">{l s='(tax excl.)' mod='roja45productrental'}</span>
                                    </td>
                                    <td class="price">{displayPrice price={toolsConvertPrice price=$total_to_pay}}</td>
                                </tr>
                                <tr>
                                    <td class="text-right">{l s='Taxes' mod='roja45productrental'}</td>
                                    <td class="price">{displayPrice price={toolsConvertPrice price=$taxes}}</td>
                                </tr>
                                {if !($display_without_tax)}
                                    <tr>
                                        <td class="text-right">{l s='Total To Pay' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(tax incl.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{displayPrice price={toolsConvertPrice price=$total_to_pay_with_tax}}</td>
                                    </tr>
                                    {if isset($total_deposit_to_pay_with_tax)}
                                        <tr>
                                            <td class="text-right total-to-pay-header">{l s='Total To Pay Now' mod='roja45productrental'}</td>
                                            <td class="price total-to-pay total-to-pay-with-tax">{displayPrice price={toolsConvertPrice price=$total_deposit_to_pay_with_tax}}</td>
                                        </tr>
                                    {/if}
                                {else}
                                    {if isset($total_deposit_to_pay)}
                                        <tr>
                                            <td class="text-right total-to-pay-header">{l s='Total To Pay Now' mod='roja45productrental'}</td>
                                            <td class="price total-to-pay">{displayPrice price={toolsConvertPrice price=$total_deposit_to_pay}}</td>
                                        </tr>
                                    {/if}
                                {/if}
                                <tr>
                                    <td class="text-right" colspan="2">
                                        {if isset($total_deposit_to_pay) && total_deposit_to_pay > 0}
                                            <p class="roja45_productrental_notes">{l s='The required payment has been calculated and added to your cart, any remainder should be paid on collection.' mod='roja45productrental'}</p>
                                        {/if}
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- End roja45productrental_booking_details_container -->
</div>