/* global $ */
$(document).ready(function () {

    var $searchWidget = $('#search_widget');
    var $searchBox    = $searchWidget.find('input[type=text]');
    var searchURL     = $searchWidget.attr('data-search-controller-url');
    var marker_class  = 'pk_search_result';
    var noproducts    = 'search-no-result';
    var fadeContent   = 'fadeContent';

    $.widget('prestashop.psBlockSearchAutocomplete', $.ui.autocomplete, {
        _renderItem: function (ul, product) {
            ul.addClass(marker_class).css({'width': $searchBox.width()+'px'});
            if (product.discount !== null) {
              var oldprice = '<span class="regular-price">'+product.regular_price+'</span>';
            } else {
              var oldprice = '';
            }

            return $("<li>")
                .append($(
                    '<div class="mini-product"><div class="thumbnail-container relative"><div class="thumbnail product-thumbnail"><a href="'+product.link+'" class="relative"><img src="'+product.cover.medium.url+'"></a></div><div class="product-description"><h3 class="product-title"><a href="'+product.link+'">'+product.name+'</a></h3><div class="product-price-and-shipping"><span class="price">'+product.price+'</span></div></div></div>')
                ).appendTo(ul);

        }
    });

    $searchBox.psBlockSearchAutocomplete({
        source: function (query, response) {
            $.get(searchURL, {
                s: query.term,
                resultsPerPage: 10
            }, null, 'json')
            .then(function (resp) {
                $searchWidget.addClass('shown');

                if (typeof theme_cfg.ps_version !== 'undefined') {
                  if (theme_cfg.ps_version < 1730) {
                    covers = getCovers(resp.products);
                    if (typeof covers === 'object') {
                      $.each( resp.products, function( key, value ) {
                        resp.products[key]['cover']['small']['url'] = covers[value.id_product];
                      });
                    }   
                  }
                }
                if (resp.products.length > 0 && query.term.length > 2) {
                  $searchWidget.css({'top':'10%'});
                  response(resp.products);
                  $('.'+noproducts).remove();
                } else {
                  $searchWidget.removeAttr('style');
                  $('.ui-autocomplete-input').removeClass('ui-autocomplete-loading');
                  $('.ui-autocomplete').hide();
                  $('.'+noproducts).remove();
                  if (query.term.length <= 2) {
                    var txt = $searchWidget.data('less');
                    $searchWidget.append('<div class="'+noproducts+' '+marker_class+'">'+txt+'</div>');
                  } else {
                    var txt = $searchWidget.data('null');
                    $searchWidget.append('<div class="'+noproducts+' '+marker_class+'">'+txt+'</div>');
                  }
                }
            })
            .fail(response);
        },
        select: function (event, ui) {
            var url = ui.item.url;
            window.location.href = url;
        },
    });


    var target = document.getElementById('ui-id-1');
    var observer = new MutationObserver(function(mutations) {
      mutations.forEach(function(mutation) {

        if ( $(target).css('display') == 'none' ){
            $searchWidget.removeClass('shown');
        }

      });
    });

    var config = { attributes: true, childList: false, characterData: false };
    if (target) {
      observer.observe(target, config);
    }

    function getCovers(products)
    {
      var data = new Object();
      $.each(products, function(key, value) {
        data[value.id_product] = value.link_rewrite;
      });

      $.ajax({
          type: 'POST',
          async:false,
          url: prestashop.urls.base_url + 'modules/pk_themesettings/ajax.php?getCovers=1&data='+JSON.stringify(data),
          success: function(result){
            if (result == '0') {
              covers = false;
            } else {
              covers = jQuery.parseJSON(result);
            }
          }
      });
      return covers;
    }

    $('body').on('click', '.searchToggler', function(){
      $searchWidget.toggleClass('hidden').css({'top':'50%'});
      $('body').append('<div class="'+fadeContent+'"></div>');
    });
    $('body').on('click', '.'+fadeContent, function(){
      $('.'+fadeContent).remove();
      $searchWidget.toggleClass('hidden');
    });
});