{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{if isset($product.product_settings)}
  {assign var="pp" value=$product.product_settings}
{/if}
{if isset($image_size)}
  {assign var="type" value=$image_size}
{else}
  {assign var="type" value='home_default'}
{/if}
{block name='product_miniature_item'}
<article class="product-miniature js-product-miniature{if $product.quantity == 0} out-of-stock{/if}{if (isset($product.new) && $product.new == 1)} new{/if}{if (isset($product.bestseller) && ($product.bestseller == 1))} bestsellers{/if}{if (isset($product.featured) && $product.featured == 1)} featured{/if}{if (isset($product.reduction) && $product.reduction > 0)} discount{/if}{if isset($product.all_cats)} {$product.all_cats}{else}{if isset($product.category)} {$product.category}{/if}{/if}" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
  <meta itemprop="description" content="{$product.manufacturer_name} {$product.name}" />
  <meta itemprop="image" content="{$product.cover.large.url}" />
  <meta itemprop="sku" content="{$product.quantity}" />
  <meta itemprop="itemCondition" content="{$product.condition}" />
  <meta itemprop="gtin13" content="{$product.ean13}" />
  <div itemprop="brand" itemtype="http://schema.org/Thing" itemscope>
    <meta itemprop="name" content="{$product.manufacturer_name}" />
  </div>
  
  <div class="thumbnail-container relative">

    <div class="thumbnail product-thumbnail relative flex-container">

      {block name='product_thumbnail'}
      <a href="{$product.url}" class="relative{foreach from=$product.images item=image}{if ($image.cover != 1)} subimage-true{break}{/if}{/foreach}">
        {if $product.cover}
          {include file='catalog/_partials/product-image.tpl' image=$product.cover type=$type}
          {if Configuration::get('pm_hover_image') == true}
            {foreach from=$product.images item=image}
              {if ($image.cover != 1)}
                {include file='catalog/_partials/product-image.tpl' image=$image type=$type}
                {break}
              {/if}
            {/foreach}
          {/if}
        {else}
          <img src="{$urls.no_picture_image.bySize.large_default.url}" style="width:100%;">
        {/if}
      </a>
      {/block}

      {block name='product_buy'}
        <div class="product-actions">

          {if Configuration::get('pm_qw_button') == true}
            <a href="#" class="quick-view btn btn-primary smooth05" data-link-action="quickview" title="{l s='Quick view' d='Shop.Theme.Actions'}" aria-label="{l s='Quick view' d='Shop.Theme.Actions'}" role="button">
              <svg class="svgic svgic-search"><use xlink:href="#si-search"></use></svg>
            </a>
          {/if}

          {if ($product.quantity > 0) && ($page.page_name !== 'product') && ($product.available_for_order == 1) && ($product.customizable == 0)}

            {if ( ((Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY') == 1) && (!empty($product.main_variants))) || (Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY') == 1 || empty($product.main_variants)) )}

              <form action="{$urls.pages.cart}" method="post" class="add-to-cart-or-refresh">
                <input type="hidden" name="token" value="{if (isset($static_token))}{$static_token}{/if}">
                <input type="hidden" name="id_product" value="{$product.id}" class="product_page_product_id">
                {block name='product_add_to_cart'}
                  {include file='catalog/_partials/product-add-to-cart-mini.tpl'}
                {/block}
              </form>

            {/if}
          {else}
            <a href="{$product.url}" class="btn smooth05" title="{l s='View Product' d='Shop.Theme.Actions'}" aria-label="{l s='View Product' d='Shop.Theme.Actions'}" role="button">
              <svg class="svgic svgic-button-cart"><use xlink:href="#si-eye2"></use></svg>
            </a>
          {/if}

          {hook h='compareButton' product_id=$product.id}

        </div>
      {/block}

      {if Configuration::get('pm_countdown') == true}
        {include file='catalog/_partials/miniatures/countdown.tpl'}
      {/if}

    </div>

    <div class="product-desc-wrap">

      <div class="product-description clearfix">

        {if Configuration::get('pm_brand') == true}
          {if (isset($product.manufacturer_name))}
          {block name='product_manufacturer'}
            <h6 class="product-brand ellipsis">{$product.manufacturer_name}</h6>
          {/block}
          {/if}
        {/if}

        {if Configuration::get('pm_title') == true}
        {block name='product_name'}
          <h3 class="product-title text-left{if Configuration::get('pm_title_multiline') == true} ellipsis{/if}" itemprop="name">
            <a href="{$product.url}">{if (is_array($product.name))}{$product.name.1}{else}{$product.name}{/if}</a>
          </h3>
        {/block}
        {/if}

        {if Configuration::get('pm_price') == true}
        {block name='product_price_and_shipping'}

          {if $product.show_price}
            <div class="product-price-and-shipping">

              {if $product.has_discount}

                {hook h='displayProductPriceBlock' product=$product type="old_price"}
                <span class="regular-price">{$product.regular_price}</span>
                {if $product.discount_type === 'percentage'}
                  {if (isset($product.discount_percentage))}
                  <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
                  {/if}
                {elseif $product.discount_type === 'amount'}
                  {if (isset($product.discount_amount_to_display))}
                  <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
                  {/if}
                {/if}

              {/if}

              {hook h='displayProductPriceBlock' product=$product type="before_price"}
              <span class="price">{$product.price}</span>
              {hook h='displayProductPriceBlock' product=$product type='unit_price'}
              {hook h='displayProductPriceBlock' product=$product type='weight'}

            </div>
          {/if}
        {/block}
        {/if}

        {block name='product_description_short'}
          <div class="short-desc product-description-short{if Configuration::get('pm_desc') == true} shown{else} hidden{/if}" itemprop="description">
            {$product.description_short nofilter}
          </div>
        {/block}

        {if Configuration::get('pm_stars') == true}
        {capture name='displayProductListReviews'}{hook h='displayProductListReviews' product=$product}{/capture}
        {if $smarty.capture.displayProductListReviews}
          <div class="hook-reviews">
          {hook h='displayProductListReviews' product=$product}
          </div>
        {/if}
        {/if}

      </div>

      {if Configuration::get('pm_labels') == true}
        {block name='product_flags'}
          <ul class="product-flags">
            {foreach from=$product.flags item=flag}
              <li class="{$flag.type}">{$flag.label}</li>
            {/foreach}
            {if !empty($product.discount_percentage)}
            <li class="discount-perc">{$product.discount_percentage}</li>
            {/if}
          </ul>
        {/block}
      {/if}

      {if Configuration::get('pm_colors') == true}
      <div class="highlighted-informations{if !$product.main_variants} no-variants{/if}">
          {block name='product_variants'}
            {include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
          {/block}
      </div>
      {/if}

    </div>

  </div>

</article>
{/block}