{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{extends file=$layout}

{block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
{/block}

{block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
    <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
    <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
    <meta property="product:price:amount" content="{$product.price_amount}">
    <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
  <meta property="product:weight:value" content="{$product.weight}">
  <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
{/block}

{block name='content'}

  {if (isset($pkts.pp_builder_layout) && ($pkts.pp_builder_layout != 0))}

      {hook h='displayProductBuilder'}

      {block name='product_images_modal'}
        {include file='catalog/_partials/product-images-modal.tpl'}
      {/block}

  {else}

  <section id="main" itemscope itemtype="https://schema.org/Product" data-id_product_attribute="{$product.id_product_attribute}"  data-id_product="{$product.id_product}">
    <meta itemprop="url" content="{$product.url}">
    <meta itemprop="sku" content="{$product.quantity}" />
    <meta itemprop="gtin13" content="{$product.ean13}" />
    <div itemprop="brand" itemtype="http://schema.org/Thing" itemscope>
      <meta itemprop="name" content="{$product_manufacturer->name}" />
    </div>

    <div class="row product-page-col page-width{if (isset($pkts) && ($pkts.pp_updownbuttons == 0))} hide-updownbuttons{/if}">
      <div class="col-md-6">
        {block name='page_content_container'}
          <section class="page-content" id="content">
            {block name='page_content'}
              {block name='product_flags'}
                <ul class="product-flags">
                  {foreach from=$product.flags item=flag}
                    <li class="product-flag {$flag.type}">{$flag.label}</li>
                  {/foreach}
                  {if $product.has_discount}
                    {if $product.discount_type === 'percentage'}
                      <li class="product-flag discount">{l s='Save %percentage%' d='Shop.Theme.Catalog' sprintf=['%percentage%' => $product.discount_percentage_absolute]}</li>
                    {else}
                      <li class="product-flag discount">
                          {l s='Save %amount%' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.discount_to_display]}
                      </li>
                    {/if}
                  {/if}
                </ul>
              {/block}

              {block name='product_cover_tumbnails'}
                {include file='catalog/_partials/product-cover-thumbnails.tpl'}
              {/block}

            {/block}
          </section>
        {/block}
        </div>
        <div class="col-md-6 product-info-section">

          {block name='page_header_container'}
            {block name='page_header'}
              <a class="product-brand" href="{$product_brand_url}">{$product_manufacturer->name}</a>
              <h1 class="h1" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
            {/block}
          {/block}

          {block name='system_info'}
          <div class="sys-info-section">
          <div class="sys-info flex-container">{hook h='displayProductRating' product=$product.id}</div>
          </div>
          {/block}

          {block name='product_prices'}
            {include file='catalog/_partials/product-prices.tpl'}
          {/block}

          <div class="product-information">
            {block name='product_description_short'}
              <div id="product-description-short-{$product.id}" class="short-desc" itemprop="description">{$product.description_short nofilter}</div>
            {/block}

            {if $product.is_customizable && count($product.customizations.fields)}
              {block name='product_customization'}
                {include file="catalog/_partials/product-customization.tpl" customizations=$product.customizations}
              {/block}
            {/if}

            <div class="product-actions">
              {block name='product_buy'}
                <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
                  <input type="hidden" name="token" value="{if (isset($static_token))}{$static_token}{/if}">
                  <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
                  <input type="hidden" name="id_customization" value="{$product.id_customization}" id="product_customization_id">

                  {block name='product_variants'}
                    {include file='catalog/_partials/product-variants.tpl'}
                  {/block}

                  {block name='product_pack'}
                    {if $packItems}
                      <section class="product-pack">
                        <h3 class="h4">{l s='This pack contains' d='Shop.Theme.Catalog'}</h3>
                        {foreach from=$packItems item="product_pack"}
                          {block name='product_miniature'}
                            {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack}
                          {/block}
                        {/foreach}
                      </section>
                    {/if}
                  {/block}

                  {block name='product_discounts'}
                    {include file='catalog/_partials/product-discounts.tpl'}
                  {/block}

                  {block name='product_add_to_cart'}
                    {include file='catalog/_partials/product-add-to-cart.tpl'}
                  {/block}

                  <div class="productButtons flex-container align-items-center">
                    {hook h='displayMoreButtons' product_id=$product.id}
                  </div>

                  {block name='product_additional_info'}
                    {include file='catalog/_partials/product-additional-info.tpl'}
                  {/block}

                  {block name='product_refresh'}
                    <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit" value="{l s='Refresh' d='Shop.Theme.Actions'}">
                  {/block}
                  
                </form>
              {/block}

            </div>

            {hook h='displayReassurance'}

        </div>
      </div>
    </div>

    {block name='product_tabs'}
    <div class="tabs-container">
      <div class="tabs page-width">
        <ul class="nav nav-tabs flex-container">
          {if $product.description}
          <li class="nav-item">
            <a class="nav-link{if $product.description} active{/if}" data-toggle="tab" href="#description"><h5>{l s='Description' d='Shop.Theme.Catalog'}</h5></a>
          </li>
          {/if}
          <li class="nav-item">
            <a class="nav-link{if !$product.description} active{/if}" data-toggle="tab" href="#product-details"><h5>{l s='Product Details' d='Shop.Theme.Catalog'}</h5></a>
          </li>
          {if $product.attachments}
          <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#attachments"><h5>{l s='Attachments' d='Shop.Theme.Catalog'}</h5></a>
          </li>
          {/if}
          {foreach from=$product.extraContent item=extra key=extraKey}
          <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#extra-{$extraKey}"><h5>{$extra.title}</h5></a>
          </li>
          {/foreach}

          {hook h='productTab'}

        </ul>

        <div class="tab-content" id="tab-content">
         <div class="tab-pane fade in{if $product.description} active{/if}" id="description">
           {block name='product_description'}
             <div class="product-description">{$product.description nofilter}</div>
           {/block}
         </div>

         {block name='product_details'}
           {include file='catalog/_partials/product-details.tpl'}
         {/block}

         {block name='product_attachments'}
           {if $product.attachments}
            <div class="tab-pane fade in" id="attachments">
               <section class="product-attachments">
                 <h3 class="h5 text-uppercase">{l s='Download' d='Shop.Theme.Actions'}</h3>
                 {foreach from=$product.attachments item=attachment}
                   <div class="attachment">
                     <h4><a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a></h4>
                     <p>{$attachment.description}</p
                     <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                       {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
                     </a>
                   </div>
                 {/foreach}
               </section>
             </div>
           {/if}
         {/block}
         {foreach from=$product.extraContent item=extra key=extraKey}
         <div class="tab-pane fade in {$extra.attr.class}" id="extra-{$extraKey}" {foreach $extra.attr as $key => $val} {$key}="{$val}"{/foreach}>
             {$extra.content nofilter}
         </div>
         {/foreach}

         {hook h='productTabContent'}

        </div>
      </div>
    </div>
    {/block}

    {block name='product_accessories'}
      {if $accessories}
        <section class="product-accessories products-carousel page-width wide oh relative" data-num="{$accessories|count}" data-prefix="accessories">
          <div class="relative">
            <h4 class="module-title">
              <span>{l s='You might also like' d='Shop.Theme.Catalog'}</span>
            </h4>
            <div class="products pk-carousel view_grid products-block" data-desktopnum="4" data-tabletnum="3" data-phonenum="2" data-loop="0" data-autoplay="0" data-navwrap="0" data-name="accessories">
              {foreach from=$accessories item="product_accessory"}
                {block name='product_miniature'}
                  {include file='catalog/_partials/miniatures/product.tpl' product=$product_accessory image_size='medium_default'}
                {/block}
              {/foreach}
            </div>
          </div>
        </section>
      {/if}
    {/block}

    {hook h='displayAutoCompare' currentProduct=$product}

    {block name='product_footer'}
      <div class="page-width" data-hook="displayFooterProduct">
      {hook h='displayFooterProduct' product=$product category=$category}
      </div>
    {/block}

    {block name='product_images_modal'}
      <div class="page-width">
      {include file='catalog/_partials/product-images-modal.tpl'}
      </div>
    {/block}

    {block name='page_footer_container'}
      <footer class="page-footer page-width">
        {block name='page_footer'}
          <!-- Footer content -->
        {/block}
      </footer>
    {/block}
  </section>
  {/if}
{/block}