{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *
 *}
<!doctype html>
<html lang="{$language.iso_code}">

  <head>
      <!-- Global site tag (gtag.js) - Google Analytics -->
      <script async src="https://www.googletagmanager.com/gtag/js?id=UA-144586794-1"></script>
      {literal}
      <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());

          gtag('config', 'UA-144586794-1');
      </script>
          <!-- Google Tag Manager -->
          <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                  new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                  j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                  'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
              })(window,document,'script','dataLayer','GTM-PDWM5K5');</script>
          <!-- End Google Tag Manager -->
          <!-- Google Tag Manager (noscript) -->
          <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PDWM5K5"
                            height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
          <!-- End Google Tag Manager (noscript) -->
        {/literal}
      {block name='head'}
      {include file='_partials/head.tpl'}
    {/block}

  </head>

  <body id="{$page.page_name}" class="{$page.body_classes|classnames}">

    {if ((isset($pkts.gs_preloader) && $pkts.gs_preloader) && ($page.page_name == 'index'))}
      <div class="loader-bg">{include file='_partials/svg/loader-animated.svg'}</div>
    {/if}

    {block name='svg_graphics'}
      {include file="_partials/svg.tpl"}
    {/block}

    {block name='hook_after_body_opening_tag'}
      {hook h='displayAfterBodyOpeningTag'}
    {/block}

    <div class="{if isset($pkts) && isset($pkts.pattern)}back_{$pkts.pattern}{/if}" id="pattern">

      {block name='header'}
        {include file='_partials/header.tpl'}
      {/block}

      <section class="main-contant-wrapper clearfix" data-location="/templates/layouts/layout-both-columns.tpl">

      {if (isset($pkts.homepage_builder) && $pkts.homepage_builder && ($page.page_name == 'index')
          || (empty($pkts) && ($page.page_name == 'index')) )}

        {hook h="displayHomeBuilder"}

      {else}

          {if ($page.page_name == 'index')}
          {block name='top_slider'}
            {hook h='top_slider'}
          {/block}
          {/if}

          {if ($page.page_name == 'index')}
            {block name='displayTopColumn'}
            <div class="hook-displayTopColumn hook-container displayTopColumn">{hook h='displayTopColumn'}</div>
            {/block}
          {/if}

          <div class="page-width top-content">
            
            {block name='notifications'}
              {include file='_partials/notifications.tpl'}
            {/block}

            {block name='breadcrumb'}
              {include file='_partials/breadcrumb.tpl'}
            {/block}

          </div>


          {block name='content_top'}
          <div class="hook-content_top hook-container wide">{hook h='content_top'}</div>
          {/block}

          <div class="page-width main-content">

            <div id="wrapper" class="clearfix container">
              <div class="row">

              {block name='left_column'}
                <div id="left-column" class="sidebar col-xs-12 col-sm-4 col-md-3">
                  {if $page.page_name == 'product'}
                    {hook h='displayLeftColumnProduct'}
                  {else}
                    {hook h="displayLeftColumn"}
                  {/if}
                </div>
              {/block}

              {block name='right_column'}
                <div id="right-column" class="sidebar col-xs-12 col-sm-4 col-md-3">
                  {if $page.page_name == 'product'}
                    {hook h='displayRightColumnProduct'}
                  {else}
                    {hook h="displayRightColumn"}
                  {/if}
                </div>
              {/block}

              {block name='content_wrapper'}
                <div id="content-wrapper" class="wide left-column right-column">
                  {block name='content'}
                    <p>Hello world! This is HTML5 Boilerplate.</p>
                  {/block}
                </div>
              {/block}
              
              </div>
            </div>

          </div>

        {block name='content_bottom'}
        <div class="hook-content_bottom hook-container wide">{hook h='content_bottom'}</div>
        {/block}

        {block name='hook_footer_twitter'}
          {hook h='footer_twitter'}
        {/block}

      {/if}

      </section>

      <footer id="footer" class="relative">
        {block name='footer'}
          {include file='_partials/footer.tpl'}
        {/block}
      </footer>

    </div>

    {block name='javascript_bottom'}
      {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
    {/block}

    {block name='hook_before_body_closing_tag'}
      {hook h='displayBeforeBodyClosingTag'}
    {/block}

  </body>
{literal}
    
{/literal}
</html>