{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{if (isset($amp.config.general.fbpixel.state) && $amp.config.general.googleanalytics.state == 1) && (isset($amp.config.general.googleanalytics.id) && $amp.config.general.googleanalytics.id != '')}
<amp-analytics type="googleanalytics">
  <script type="application/json">
    {
      "vars": {
        "account": "{$amp.config.general.googleanalytics.id}"
      },
      "triggers": {
        "trackPageview": {
          "on": "visible",
          "request": "pageview"
        }
      }
    }
  </script>
</amp-analytics>
{/if}

{if (isset($amp.config.general.fbpixel.state) && $amp.config.general.fbpixel.state == 1) && (isset($amp.config.general.fbpixel.id) && $amp.config.general.fbpixel.id != '')}
<amp-analytics type="facebookpixel" id="facebook-pixel">
  <script type="application/json">
  {
    "vars": {
      "pixelId": "{$amp.config.general.fbpixel.id}"
    },
    "triggers": {
      "trackPageview": {
        "on": "visible",
        "request": "pageview"
      },
    }
  }
  </script>
</amp-analytics>
{/if}

{if (isset($amp.config.footer.checkoutbtn) && $amp.config.footer.checkoutbtn == 1 && isset($amp.cart.products_count))}
<div class="c-out-btn"{if $amp.cart.products_count == 0} hidden{/if} [hidden]="cartList.info[0].products_count == 0">
  <a href="{url entity='module' name='pk_amp' controller='checkout' relative_protocol=false}" class="c-out-btn" role="button" tabindex="0">
    <svg class="svgic"><use xlink:href="#si-checkout"></use></svg>
    <span [text]="cartList.info[0].products_count">{$amp.cart.products_count}</span>
  </a>
</div>
{/if}