{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

<template type="amp-mustache">
    
  <article class="product-miniature relative m40 {literal}{{has_discount}}{/literal}" data-id="{literal}{{id_product}}{/literal}">

    <a href="{literal}{{amp_link}}{/literal}" title="{literal}{{name}}{/literal}">
      <amp-img src="{literal}{{cover.medium.url}}{/literal}" width="{literal}{{cover.medium.width}}{/literal}" height="{literal}{{cover.medium.height}}{/literal}" layout="responsive" class="product-image-amp" alt="{literal}{{name}}{/literal}"></amp-img>
      {if (isset($amp.config.category.product.labels) && ($amp.config.category.product.labels == 1))}
      <ul class="product-labels">
        {if !$configuration.is_catalog}
        {literal}{{#discount_amount_to_display}}{/literal}
        <li class="discount-amount discount-product">{literal}{{discount_amount_to_display}}{/literal}
        </li>
        {literal}{{/discount_amount_to_display}}{/literal}
        {/if}

        <li>{literal}{{flags.new.label}}{/literal}</li>

        {if !$configuration.is_catalog}
        {literal}{{^quantity_all_versions}}{/literal}
          <li>{l s='Out of Stock' d='Shop.Theme.Actions'}</li>
        {literal}{{/quantity_all_versions}}{/literal}
        {/if}
      </ul>
      {/if}
    </a>

    {if !$configuration.is_catalog}
    <div class="product-price-amp price m15 flex-container">
      {literal}{{#has_discount}}{/literal}
      <span class="discount-price">
        <span class="regular-price">{literal}{{regular_price}}{/literal}</span>
      </span>
      {literal}{{/has_discount}}{/literal}
      <span>{literal}{{price}}{/literal}</span>
    </div>
    {/if}

    <div class="width-float ellipsis product-title m15">
      <a href="{literal}{{amp_link}}{/literal}" title="{literal}{{name}}{/literal}">{literal}{{name}}{/literal}</a>
    </div>

    {if !$configuration.is_catalog}
    <form method="POST" action-xhr="{url entity='module' name='pk_amp' controller='ajaxCart' params=['who' => 'category-add_to_cart']}" target="_top" class="flex-container align-items-center" on="{literal}submit-success: AMP.setState({ cartList: { items: event.response.items, info: event.response.info } });{/literal}">

      <input type="hidden" name="act" value="up">
      <input type="hidden" name="do" value="cartUpdate">
      <input type="hidden" name="id_product" value="{literal}{{id_product}}{/literal}">
      <input type="hidden" name="id_product_attribute" value="{literal}{{id_product_attribute}}{/literal}">
      <button type="submit" class="add-to-cart big-btn">{l s='Add to cart' d='Shop.Theme.Amp'}</button>

      <div submit-success><div class="flex-container align-items-center"><span>{l s='Success' d='Shop.Theme.Amp'}&nbsp;</span><amp-bodymovin-animation layout="flex-item" width="34" height="34" src="{$amp.global.assets}json/success.json" loop="false"></amp-bodymovin-animation></div></div>
      <div submit-error>{l s='Unable to Add to cart' d='Shop.Theme.Amp'}</div>
      <div submitting>{l s='Waiting' d='Shop.Theme.Amp'}...</div>

    </form>
    {/if}

  </article>

</template>