{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

<amp-accordion class="product-sorting m20" expand-single-section animate>
  <section>
    <h4>
      <div class="roboto flex-container align-items-center">
      <span class="flex-grow1 flex-container align-items-center filter-title">
        <amp-bodymovin-animation layout="flex-item" class="filter-title-icon" width="24" height="24" src="{$amp.global.assets}json/filter.json" loop="true"></amp-bodymovin-animation>
        <span class="flex-grow1">{l s='Product Filter' d='Shop.Theme.Amp'}</span>
      </span>
      <svg class="svgic smooth"><use xlink:href="#si-top-arrow-thin"></use></svg>
      </div>
    </h4>

    <form method="GET" action="{$amp.global.urls.productListSource}" action-xhr="{$amp.global.urls.productListSource}" target="_top" on="{literal}submit-success: AMP.setState({ productsList: { items: event.response.items },
      productState: {
        moreItemsPageIndex: productState.moreItemsPageIndex + 1,
        hasMorePages: event.response.hasMorePages
      } });{/literal}">
      {if (isset($facets))}
      {foreach from=$facets item="facet" name=facet}
      {if $facet.displayed == 1 && $facet.type != 'price'}
        <amp-accordion class="facet" expand-single-section animate>
        <section{if ($smarty.foreach.facet.index == 0)} expanded{/if}>
        {assign var=_expand_id value=10|mt_rand:100000}
        <h5 class="facet-title">
          <div class="roboto flex-container align-items-center">
          <div class="flex-grow1">{$facet.label}</div>
          <svg class="svgic smooth"><use xlink:href="#si-top-arrow-thin"></use></svg>
          </div>
        </h5>
        {if $facet.widgetType !== 'dropdown'}
          <ul id="facet_{$_expand_id}">
            {foreach from=$facet.filters item="filter"}
              {if $filter.displayed == 1}
              {assign var=filter_id value=10|mt_rand:100000}
                <li{if isset($filter.properties.color) || isset($filter.properties.texture)} class="color-label"{/if}>
                  <label class="facet-label flex-container align-items-center{if $filter.active == 1} active{/if}" for="filter_{$filter_id}">
                    {if $facet.multipleSelectionAllowed}
                      {if ($filter.type == 'attribute_group') || ($filter.type == 'feature')}
                        {assign var=att_name value="attr[{$facet.label}][]"}
                        {assign var=att_value value=$filter.label}
                      {else}
                        {assign var=att_name value="id_{$filter.type}"}
                        {assign var=att_value value=$filter.value}
                      {/if}
                      <input type="checkbox" class="pk-check" id="filter_{$filter_id}" name="{$att_name}" value="{$att_value}" {if $filter.active == 1} checked{/if}>
                      <div class="flex-label-wrap flex-container">
                        {if isset($filter.properties.color)}
                          <span class="color" style="background-color:{$filter.properties.color}">y</span>
                        {elseif isset($filter.properties.texture)}
                          <span class="color texture" style="background-image:url({$filter.properties.texture})">x</span>
                        {else}
                          <span></span>
                        {/if}
                        <svg width="18px" height="18px" viewBox="0 0 18 18">
                          <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                          <polyline points="1 9 7 14 15 4"></polyline>
                        </svg>
                      </div>
                    {else}
                      <input type="radio" name="{$facet.label}"{if $filter.active == 1} checked{/if}>
                    {/if}
                    <span class="flex-grow1 search-link js-search-link" rel="nofollow">
                      {$filter.label}
                      {if $filter.magnitude}
                        <span class="magnitude">({$filter.magnitude})</span>
                      {/if}
                    </span>
                    {if $facet.multipleSelectionAllowed}
                      {if isset($filter.properties.color)}
                        <span class="color-tooltip" style="background-color:{$filter.properties.color}"></span>
                      {elseif isset($filter.properties.texture)}
                        <span class="color-tooltip" style="background-image:url({$filter.properties.texture})"></span>
                      {/if}
                    {/if}
                  </label>
                </li>
              {/if}
            {/foreach}
          </ul>
        {else}
          <ul id="facet_{$_expand_id}">
            <li>
              <div class="facet-dropdown dropdown">
                <a class="select-title" rel="nofollow" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  {$active_found = false}
                  <span>
                    {foreach from=$facet.filters item="filter"}
                      {if $filter.active == 1}
                        {$filter.label}
                        {if $filter.magnitude}
                          ({$filter.magnitude})
                        {/if}
                        {$active_found = true}
                      {/if}
                    {/foreach}
                    {if !$active_found}
                      {l s='(no filter)' d='Shop.Theme.Global'}
                    {/if}
                  </span>
                  <i class="material-icons pull-xs-right">&#xE5C5;</i>
                </a>
                <div class="dropdown-menu">
                  {foreach from=$facet.filters item="filter"}
                    {if $filter.active !== 1}
                      <a rel="nofollow" href="#" class="select-list">
                        {$filter.label}
                        {if $filter.magnitude}
                          ({$filter.magnitude})
                        {/if}
                      </a>
                    {/if}
                  {/foreach}
                </div>
              </div>
            </li>
          </ul>
        {/if}
        </section>
        </amp-accordion>
      {/if}
      {/foreach}
      {/if}

      <!-- SORTING -->
      <div class="ampstart-input m15 flex-container">
        <label class="flex-grow1">{l s='Sort By' d='Shop.Theme.Amp'}:</label>
        <select name="sortOrder">
          <option value="position.asc">{l s='Relevance' d='Shop.Theme.Amp'}</option>
          <option value="name.asc">{l s='Name, A to Z' d='Shop.Theme.Amp'}</option>
          <option value="name.desc">{l s='Name, Z to A' d='Shop.Theme.Amp'}</option>
          <option value="price.asc">{l s='Price, low to high' d='Shop.Theme.Amp'}</option>
          <option value="price.desc">{l s='Price, high to low' d='Shop.Theme.Amp'}</option>
          <option value="date_add.asc">{l s='Add date, old to new' d='Shop.Theme.Amp'}</option>
          <option value="date_add.desc">{l s='Add date, new to old' d='Shop.Theme.Amp'}</option> 
        </select>
      </div>
      <!-- /SORTING -->

      <!-- PRODUCTS PER PAGE -->
      <div class="ampstart-input flex-container relative m1 m15">
        <label class="flex-grow1">{l s='Products Per Page' d='Shop.Theme.Amp'}:</label>
        <select name="productsPerPage">
          {foreach from=$amp.listing.products_per_page key=id item=num}
          <option value="{$num}"{if $id == 1} selected{/if}>{$num}</option>
          {/foreach}
        </select>
      </div>
      <!-- /PRODUCTS PER PAGE -->

      <div class="form-footer flex-container align-items-center">
        <input type="submit" value="{l s='Apply' d='Shop.Theme.Amp'}" class="ampstart-btn big-btn caps m1 show">

        <div submit-success>
          <div class="flex-container align-items-center">
            <amp-bodymovin-animation layout="flex-item" width="34" height="34" src="{$amp.global.assets}json/success.json" loop="false"></amp-bodymovin-animation>
            <div>{l s='Done' d='Shop.Theme.Amp'}</div>
          </div>
        </div>
        <div submit-error>&nbsp;{l s='Unable to Sort Products' d='Shop.Theme.Amp'}</div>
        <div submitting>&nbsp;{l s='Waiting' d='Shop.Theme.Amp'}...</div>
      </div>

    </form>
  </section>
</amp-accordion>