{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}


{block name='content'}

{assign var="productListSource" value="{url entity='module' name='pk_amp' controller='ajaxFilter'}"}

  {if $category->id_image}
    <div id="category-image-amp">
      <amp-img src="{url entity='categoryImage' id=$category->id_category name='category_default'}"
        width="{$amp.global.images.category.size.width}" height="{$amp.global.images.category.size.height}" layout="responsive" alt="{$category->name}"></amp-img>
      </amp-carousel>
    </div>
  {/if}

  {if ($category->name !== '')}
  <h2 id="category-name-amp">
    <a href="{url entity='category' id=$category->id_category id_lang=$language.id}">
      {$category->name}
    </a>
  </h2>
  {/if}

  {if ($category->clean_description !== '')}
  <div>{$category->clean_description nofilter}</div>
  {/if}
<!--
  <amp-accordion expand-single-section animate>
    <section>
      <h4>Product Filter</h4>
      <div>
        {foreach from=$facets item="facet"}
          {if $facet.displayed == 1}
            <section class="facet" data-s="{$facet.displayed}">
              {assign var=_expand_id value=10|mt_rand:100000}
              <h4 class="module-title facet-title">
                <span class="title-text">{$facet.label}</span>
              </h4>
              {if $facet.widgetType !== 'dropdown'}
              {block name='facet_item_other'}
                <ul id="facet_{$_expand_id}">
                  {foreach from=$facet.filters item="filter"}
                    {if $filter.displayed == 1}
                      <li>
                        <label class="facet-label{if $filter.active == 1} active{/if}">
                          {if $facet.multipleSelectionAllowed}
                            <input type="checkbox" name="{$filter.type}" value="{$filter.value}" {if $filter.active == 1} checked{/if} on="{literal}change:AMP.setState({
                              query: event.value,
                              });
                            {/literal}">
                            {if isset($filter.properties.color)}
                              <span class="color" style="background-color:{$filter.properties.color}">y</span>
                              {elseif isset($filter.properties.texture)}
                                <span class="color texture" style="background-image:url({$filter.properties.texture})">x</span>
                              {else}
                              <span></span>
                            {/if}
                          {else}
                              <input type="radio" name="{$facet.label}" {if $filter.active == 1} checked{/if} on="{literal}{/literal}">

                              
                          {/if}

                          <a href="#" class="_gray-darker search-link js-search-link" rel="nofollow">
                            {$filter.label}
                            {if $filter.magnitude}
                              <span class="magnitude">({$filter.magnitude})</span>
                            {/if}
                          </a>
                          
                          {if $facet.multipleSelectionAllowed}
                              {if isset($filter.properties.color)}
                                <span class="color-tooltip" style="background-color:{$filter.properties.color}"></span>
                              {elseif isset($filter.properties.texture)}
                                <span class="color-tooltip" style="background-image:url({$filter.properties.texture})"></span>
                              {/if}
                          {/if}
                          
                        </label>
                      </li>
                    {/if}
                  {/foreach}
                </ul>
                {/block}
              {else}
                {block name='facet_item_dropdown'}
                  <ul id="facet_{$_expand_id}">
                    <li>
                      <div class="col-sm-12 col-xs-12 col-md-12 facet-dropdown dropdown">
                        <a class="select-title" rel="nofollow" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          {$active_found = false}
                          <span>
                            {foreach from=$facet.filters item="filter"}
                              {if $filter.active == 1}
                                {$filter.label}
                                {if $filter.magnitude}
                                  ({$filter.magnitude})
                                {/if}
                                {$active_found = true}
                              {/if}
                            {/foreach}
                            {if !$active_found}
                              {l s='(no filter)' d='Shop.Theme.Global'}
                            {/if}
                          </span>
                          <i class="material-icons pull-xs-right">&#xE5C5;</i>
                        </a>
                        <div class="dropdown-menu">
                          {foreach from=$facet.filters item="filter"}
                            {if $filter.active !== 1}
                              <a rel="nofollow" href="#" class="select-list">
                                {$filter.label}
                                {if $filter.magnitude}
                                  ({$filter.magnitude})
                                {/if}
                              </a>
                            {/if}
                          {/foreach}
                        </div>
                      </div>
                    </li>
                  </ul>
                {/block}
              {/if}
            </section>
          {/if}
        {/foreach}
      </div>
    </section>
  </amp-accordion>



  <amp-state id="products" [src]="'{url entity='module' name='pk_amp' controller='ajaxFilter'}'">
     <script type="application/json">
      {
        "pList": [],
        "listSrc": "",
        "query": "",
        "endpoint": ""
      }
     </script>
  </amp-state>

  <amp-list id="product-list" layout="fixed-height" height="500" items="pList" [src]="query ? products.endpoint + query : products.emptyAndInitialTemplateJson">
            
    <template type="amp-mustache">

       <div class="select-option no-outline flex-container search-item" role="option" tabindex="0" on="{literal}tap:AMP.navigateTo(url='{{link}}'){/literal}" option="{literal}{{name}}{/literal}">

          <amp-img alt="{literal}{{name}}{/literal}" src="{literal}{{image}}{/literal}" width="{$amp.global.images.small.size.width}" height="{$amp.global.images.small.size.height}"></amp-img>

          <div class="product-info">
            {literal}{{name}}{/literal}<br>
            <strong>{literal}{{price}}{/literal}</strong>
          </div>

       </div>

    </template>

  </amp-list>
-->

<!-- SORTING -->
<div class="ampstart-input inline-block relative m1">
  <select id="sortOrder" on="change:AMP.setState({
    productList: {
      sortOrder: event.value,
      listSrc: '{$productListSource}sortOrder='+event.value
    }
  })">
    <option value="price-descendent">Price high to low</option>
    <option value="price-ascendent">Price low to high</option>
  </select>
</div>
<!-- /SORTING -->

<!-- PRODUCT LIST -->
<amp-list src="{$productListSource}" [src]="productsState.items" layout="fixed-height" width="auto" height="600" class="m1">

  <template type="amp-mustache">
      
      <article class="product-miniature relative js-product-miniature" itemscope itemtype="https://schema.org/Product">

        <amp-img src="{literal}{{cover.medium.url}}{/literal}" width="{literal}{{cover.medium.width}}{/literal}" height="{literal}{{cover.medium.height}}{/literal}" layout="responsive" class="product-image-amp" alt="{literal}{{name}}{/literal}"></amp-img>

        <h5 class="width-float product-name-amp">
          <a href="{$product.link}" title="{literal}{{name}}{/literal}">{literal}{{name}}{/literal}</a>
        </h5>

        <p class="product-price-amp">
          <span>{literal}{{price}}{/literal}</span>
        </p>

        <p class="product-add-to-cart-amp">
          <a class="btn btn-primary">
            {l s='Add to cart' d='Shop.Theme.Amp'}
          </a>
        </p>

      </article>

  </template>
</amp-list>
<!-- /PRODUCT LIST -->

<!-- LOAD MORE BUTTON -->
<amp-state id="productsState" src="{$productListSource}">
</amp-state>

<amp-state id="productList">
  <script type="application/json">
    {literal}{
      "moreItemsPageIndex": 1,
      "sortOrder": "",
      "hasMorePages": 1,
      "id_category": {/literal}{$category->id}{literal}
    }{/literal}
  </script>
</amp-state>

<form method="GET" action="{$productListSource}" action-xhr="{$productListSource}" target="_top"
  on="{literal}submit-success: AMP.setState({
    productsState: {
      items: productsState.items.concat(event.response.items)
    },
    productList: {
      moreItemsPageIndex: productList.moreItemsPageIndex + 1,
      hasMorePages: event.response.hasMorePages
    }
  });{/literal}">
  <input type="hidden" name="moreItemsPageIndex" value="1" [value]="productList.moreItemsPageIndex">
  <input type="submit" value="Show more" class="ampstart-btn caps m1 show"
    [class]="(productList.hasMorePages == 0 ? 'hide' : 'ampstart-btn caps m1 mb3 show')">
</form>

<!-- /LOAD MORE BUTTON -->

{/block}