{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}

{block name='head_styles' append}
{/block}

{block name='head_scripts' append}
<script type="application/ld+json">
{literal}
{
  "@context": "https://schema.org",
  "@type": "CollectionPage",
  "@id": "",
  "mainEntity": {
    "@type": "ItemList",
    "itemListElement": [
      {"@type": "Product"},
      {"@type": "Product"}
    ]
  }
}
{/literal}
</script>
{/block}

{block name='content'}

{assign var="productListSource" value="{url entity='module' name='pk_amp' relative_protocol=false controller='ajaxFilter' params=['id_category' => $category->id]}"}
{assign var="cartURL" value="{url entity='module' name='pk_amp' controller='ajaxCart' relative_protocol=false params=['who' => 'category-main']}"}

{if (isset($amp.config.category.image) && ($amp.config.category.image == 1))}
{if $category->id_image}
  <div id="category-image-amp" class="m20">
    <amp-img src="{url entity='categoryImage' id=$category->id_category name='category_default'}"
      width="{$amp.global.images.category.size.width}" height="{$amp.global.images.category.size.height}" layout="responsive" alt="{$category->name}"></amp-img>
    </amp-carousel>
  </div>
{/if}
{/if}

{if ($category->name !== '')}
<h2 id="category-name-amp" class="roboto m20">
  <a href="{url entity='category' id=$category->id_category id_lang=$language.id}">
    {$category->name}
  </a>
</h2>
{/if}

{if (isset($amp.config.category.description) && ($amp.config.category.description == 1))}
{if ($category->description !== '')}
<div class="category-description">
  {$category->description nofilter}
</div>
{/if}
{/if}

{if (isset($amp.config.category.subcategories) && ($amp.config.category.subcategories == 1))}
{if isset($subcategories) && !empty($subcategories)}
  <div id="subcategories" class="m30">
    <amp-accordion animate>
      <section expanded>
        <h4 class="subcategory-heading m15">
          <div class="flex-container align-items-center">
          <span class="roboto flex-grow1">{l s='Subcategories'}</span>
          <svg class="svgic smooth"><use xlink:href="#si-top-arrow-thin"></use></svg>
          </div>
        </h4>
        <div class="subcategory-body">
        <ul class="flex-container">
        {foreach from=$subcategories item=subcategory}
          <li>
            <div class="subcategory-image">
              <a href="{$subcategory.amp_url}" title="{$subcategory.name}" class="db">
                {if $subcategory.id_image}
                  <amp-img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'category_default')}" alt="{$subcategory.name}" layout="responsive" width="{$amp.global.images.category.size.width}" height="{$amp.global.images.category.size.height}"></amp-img>
                {else}
                  <amp-img src="{$img_cat_dir}{$lang_iso}-default-category_default.jpg" alt="{$subcategory.name}" layout="responsive" width="{$amp.global.images.category.size.width}" height="{$amp.global.images.category.size.height}"></amp-img>
                {/if}
              </a>
            </div>
            <h5><a class="subcategory-name" href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)}">{$subcategory.name|truncate:25:'...' nofilter}</a></h5>
            {if $subcategory.description}
              <div class="cat_desc">{$subcategory.description nofilter}</div>
            {/if}
          </li>
        {/foreach}
      </ul>
      </div>
    </section>
    </amp-accordion>
  </div>
{/if}
{/if}

{if (isset($amp.config.category.product.filter) && ($amp.config.category.product.filter == 1))}
{include file='mobile/catalog/_partials/sort-orders.tpl'}
{/if}

<amp-list src="{$productListSource}" layout="fixed-height" height="580" id="productShownList" [src]="productsList.items" [height]="productsList.items.length > 0 ? productsList.items.length * 127 : 127">
  {include file='mobile/catalog/_partials/miniatures/product-miniature.tpl'}
  {if $noOfPages > 1}
  {include file='mobile/catalog/_partials/load-more.tpl'}
  {/if}
</amp-list>

{include file='mobile/catalog/_partials/product-bottom.tpl'}
{/block}