{**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}

{block name='head_styles' append}
{/block}

{block name='head_scripts' append}
<script type="application/ld+json">
{literal}
{
  "@context": "https://schema.org",
  "@type": "Brand",
  "@name": "{/literal}{$manufacturer->name}{literal}",
  "@description": "{/literal}{$manufacturer->description|strip_tags}{literal}"
}
{/literal}
</script>
{/block}

{block name='content'}

{assign var="productListSource" value="{url entity='module' name='pk_amp' controller='ajaxFilter' relative_protocol=false params=['id_manufacturer' => $manufacturer->id]}"}
{assign var="cartURL" value="{url entity='module' name='pk_amp' relative_protocol=false controller='ajaxCart' params=['who' => 'manufacturer']}"}

<div class="brand-preview">
  <amp-img class="m15" alt="{$manufacturer->logo}" src="{$manufacturer->logo}" width="{$amp.global.images.brand.size.width}" height="{$amp.global.images.brand.size.height}" layout="responsive"></amp-img>
  <h2 class="brand-name m15">{$manufacturer->name}</h2>
  <div class="brand-description">{$manufacturer->description nofilter}</div>
</div>

{include file='mobile/catalog/_partials/sort-orders.tpl'}

<!-- PRODUCT LIST -->
<amp-list src="{$productListSource}" layout="fixed-height" height="500" id="productShownList" [src]="productsList.items">
  {include file='mobile/catalog/_partials/miniatures/product-miniature.tpl'}
  {include file='mobile/catalog/_partials/load-more.tpl'}
</amp-list>
<!-- /PRODUCT LIST -->
<amp-state id="addToCart" src="{$cartURL}">
  <script type="application/json">
    {
      "productId": ""
    }
  </script>
</amp-state>

<amp-state id="productsList" src="{$productListSource}">
</amp-state>

<amp-state id="productState">
  <script type="application/json">
    {literal}{
      "moreItemsPageIndex": {/literal}{$amp.global.vars.nextPageToLoad}{literal},
      "sortOrder": "position.asc",
      "hasMorePages": 1,
      "static_token": "{/literal}{$static_token}{literal}"
    }{/literal}
  </script>
</amp-state>

{/block}