{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}

{block name='content'}

{assign var="productListSource" value="{url entity='module' name='pk_amp' relative_protocol=false controller='ajaxFilter' params=['searchstr' => $searchStr]}"}
{assign var="cartURL" value="{url entity='module' name='pk_amp' relative_protocol=false controller='ajaxCart' params=['who' => 'search']}"}

<h3 class="m15 font-normal">
{if ($searchStr != '')}
{l s='You are searching for' d='Shop.Theme.Amp'}&nbsp;<strong>"{$searchStr}"</strong>
{else}
{l s='Your search request is empty' d='Shop.Theme.Amp'}
{/if}
</h3>

{if ($searchStr != '')}
{include file='mobile/catalog/_partials/sort-orders.tpl'}

<!-- PRODUCT LIST -->
<amp-list src="{$productListSource}" layout="fixed-height" height="500" id="productShownList" [src]="productsList.items">
  
  {include file='mobile/catalog/_partials/miniatures/product-miniature.tpl'}  
  {include file='mobile/catalog/_partials/load-more.tpl'}

</amp-list>
{/if}
<!-- /PRODUCT LIST -->
<amp-state id="addToCart" src="{$cartURL}">
  <script type="application/json">
    {
      "productId": ""
    }
  </script>
</amp-state>

<amp-state id="productsList" src="{$productListSource}">
</amp-state>

<amp-state id="productState">
  <script type="application/json">
    {literal}{
      "moreItemsPageIndex": {/literal}{$amp.global.vars.nextPageToLoad}{literal},
      "sortOrder": "position.asc",
      "hasMorePages": 1,
      "static_token": "{/literal}{$static_token}{literal}"
    }{/literal}
  </script>
</amp-state>

{/block}