{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}
{block name='head_seo' append}{/block}
{block name='head_scripts' append}
<script type="application/ld+json">
{literal}
{
  "@context": "https://schema.org/",
  "@type": "Product",
  "name": "{/literal}{$product.name}{literal}",
  "image": "{/literal}{$product.cover.large.url}{literal}",
  "description": "{/literal}{$product.description_short|strip_tags:false}{literal}",
  "mpn": "{/literal}{$product.reference}{literal}",
  "brand": {
      "@type": "Brand",
      "name": "{/literal}{$product.manufacturer_name}{literal}"
  },
  {/literal}{if (isset($rating.grade))}{literal}
  "aggregateRating": {
      "@type": "AggregateRating",
      "ratingValue": "{/literal}{$rating.grade}{literal}",
      "reviewCount": "{/literal}{$rating.reviewCount}{literal}",
      "worstRating": "0",
      "bestRating": "5"
  },
  {/literal}{/if}{literal}
  "offers": {
      "@type": "Offer",
      "priceCurrency": "{/literal}{$currency.sign}{literal}",
      "price": "{/literal}{$product.price_amount}{literal}",
      "itemCondition": "https://schema.org/UsedCondition",
      "availability": "https://schema.org/InStock"
  }
}
{/literal}
</script>
{/block}
{block name='content'}   
<div class="page-content-amp">
  <div id="product-image-amp" class="m20 relative"> 
    <amp-carousel width="{$amp.global.images.large.size.width}" height="{$amp.global.images.large.size.height}" layout="responsive" type="slides"{if (isset($amp.config.product.carousel.autoplay) && ($amp.config.product.carousel.autoplay == 1))} autoplay{/if}{if (isset($amp.config.product.carousel.controls) && ($amp.config.product.carousel.controls == 1))} controls{/if} delay="{if (isset($amp.config.product.carousel.delay))}{$amp.config.product.carousel.delay}{else}3000{/if}">
      <amp-img src="{$product.cover.large.url}" width="{$amp.global.images.large.size.width}" height="{$amp.global.images.large.size.height}" alt="{$product.name}" layout="responsive">
      </amp-img>
      {if isset($product.images) && count($product.images) > 0}
        {foreach from=$product.images item=image name=thumbnails}
          {if ($image.cover != 1)}
          <amp-img src="{$image.large.url}" width="{$amp.global.images.large.size.width}" height="{$amp.global.images.large.size.height}" layout="responsive" alt="{$product.name}">
          </amp-img>
          {/if}
        {/foreach}
      {/if}
    </amp-carousel>
    <ul class="product-labels">
      {foreach from=$product.flags item=flag}
        <li class="product-flag {$flag.type}">{$flag.label}</li>
      {/foreach}
      {if $product.has_discount}
        {if $product.discount_type === 'percentage'}
          <li class="product-flag discount">{l s='Save %percentage%' d='Shop.Theme.Catalog' sprintf=['%percentage%' => $product.discount_percentage_absolute]}</li>
        {else}
          <li class="product-flag discount">
              {l s='Save %amount%' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.discount_to_display]}
          </li>
        {/if}
      {/if}
    </ul>
  </div>

  {if (isset($amp.config.product.brand) && ($amp.config.product.brand == 1))}
  {if $product.manufacturer_name != ''}
  <div class="product-brand-amp m15 text-uppercase">
    <a href="{$product.manufacturer_link}">{$product.manufacturer_name}</a>
  </div>
  {/if}
  {/if}

  <h2 class="product-name-amp m15 roboto">
    {$product.name}
  </h2>

  {if !$configuration.is_catalog}
  <div class="product-price-amp m15">
    {if ($product.has_discount)}
    <span class="discount-price">
      <span class="regular-price" [text]="attributes.regular_price">{$product.regular_price}</span>
    </span>
    {/if}
    <span itemprop="price" content="{$product.price_amount}" [text]="attributes.price" class="price">{$product.price}</span>
  </div>

  {hook h='displayProductPriceBlock' product=$product type="weight" hook_origin='product_sheet'}

  {/if}

  <div class="m15">
    {l s='Reference' d='Shop.Theme.Amp'}: {$product.reference}
  </div>

  {if (isset($amp.config.product.shortdescription) && ($amp.config.product.shortdescription == 1))}
  <div class="product-desc-amp m30">
    {$product.description_short nofilter}
  </div>
  {/if}

  {if $product.is_customizable && count($product.customizations.fields)}
  {block name='product_customization'}
    {include file="mobile/catalog/_partials/product-customization.tpl" customizations=$product.customizations}
  {/block}
  {/if}
  
  <div class="product-actions m80">

    {if (isset($amp.config.product.sizeguide) && ($amp.config.product.sizeguide == 1))}
    {if !empty($sizeGuide)}
    <amp-lightbox id="sizeguide-popup" layout="nodisplay" scrollable>
      <div class="lightbox" on="tap:sizeguide-popup.close" role="button" tabindex="0">
        <div class="space">
        {if $sizeGuide.show_measure}
        {$sizeGuide.howto nofilter}
        {/if}
        {if $sizeGuide.show_global}
        {$sizeGuide.global nofilter}
        {/if}
        </div>
      </div>
    </amp-lightbox>
    <button on="tap:sizeguide-popup">
      {l s='Size Guide' d='Shop.Theme.Amp'}
    </button>
    <br><br>
    {/if}
    {/if}

    <form id="product-attributes" method="GET" action="{url entity='module' name='pk_amp' controller='ajaxProduct' relative_protocol=false}" action-xhr="{url entity='module' name='pk_amp' controller='ajaxProduct' relative_protocol=false}" target="_top" class="flex-container align-items-center m15" on="{literal}submit-success: AMP.setState({ attributes: { price: event.response.price, regular_price: event.response.regular_price, id_product_attribute: event.response.id_product_attribute, quantity: event.response.quantity } });{/literal}">

        <input type="hidden" name="id_product" value="{$product.id_product}">
        <div class="product-variants m40 w100">

          {foreach from=$groups key=id_attribute_group item=group}
            <div class="clearfix product-variants-item m40">
              <span class="control-label db m15">{$group.name}</span>
              {if $group.group_type == 'select'}
                <select id="group_{$id_attribute_group}" class="form-control form-control-select" name="group[{$id_attribute_group}]">
                  {foreach from=$group.attributes key=id_attribute item=group_attribute}
                    <option value="{$id_attribute}" title="{$group_attribute.name}"{if $group_attribute.selected} selected="selected"{/if}>{$group_attribute.name}</option>
                  {/foreach}
                </select>
              {elseif $group.group_type == 'color'}
                <ul id="group_{$id_attribute_group}" class="flex-container attr-list m15">
                  {foreach from=$group.attributes key=id_attribute item=group_attribute}
                    <li>
                      <input hidden class="input-color" id="attr{$id_attribute}" type="radio" role="radio" tabindex="0" name="group[{$id_attribute_group}]" value="{$id_attribute}"{if $group_attribute.selected} checked aria-checked="true"{/if}>
                      <label role="button" tabindex="0" for="attr{$id_attribute}"{if $group_attribute.html_color_code} class="color" style="background-color: {$group_attribute.html_color_code}"{/if}{if $group_attribute.texture} class="color texture" style="background-image: url({$group_attribute.texture})"{/if}><span class="sr-only">{$group_attribute.name}</span></label>
                    </li>
                  {/foreach}
                </ul>
              {elseif $group.group_type == 'radio'}
                <ul id="group_{$id_attribute_group}" class="flex-container attr-list m15">
                  {foreach from=$group.attributes key=id_attribute item=group_attribute}
                    <li class="input-container relative pull-xs-left">
                      <input hidden id="attr{$id_attribute}" class="input-radio" type="radio" role="radio" tabindex="0" name="group[{$id_attribute_group}]" value="{$id_attribute}"{if $group_attribute.selected} checked aria-checked="true"{/if}>
                      <label for="attr{$id_attribute}" class="radio-label">{$group_attribute.name}</label>
                    </li>
                  {/foreach}
                </ul>
              {/if}
            </div>
          {/foreach}

          <div class="flex-container align-items-center">
          <button on="tap:product-attributes.submit">{l s='Apply Attributes' d='Shop.Theme.Amp'}</button>
          <div submitting>&nbsp;{l s='Waiting' d='Shop.Theme.Amp'}...</div>
          </div>

        </div>

      <amp-state id="attributes">
        <script type="application/json">
          {literal}
          {
            "price": "{/literal}{$product.price}{literal}",
            "regular_price": "{/literal}{$product.regular_price}{literal}",
            "id_product_attribute": "{/literal}{$product.id_product_attribute}{literal}",
            "quantity": "{/literal}{$product.quantity}{literal}"
          }
          {/literal}
         </script>
      </amp-state>

    </form>

    {if !$configuration.is_catalog}
    <span class="notification alert db text-center" hidden [hidden]="attributes.quantity != 0">{l s='No products in stock with such attributes' d='Shop.Theme.Amp'}</span>
    <form class="m40" method="POST" action-xhr="{url entity='module' name='pk_amp' controller='ajaxCart' relative_protocol=false}" target="_top" on="{literal}submit-success: AMP.setState({ cartList: { items: event.response.items, info: event.response.info}, attributes: {price: event.response.price, id_product_attribute: event.response.id_product_attribute } });{/literal}" [hidden]="attributes.quantity == 0">

      <input type="hidden" name="token" value="{$static_token}">
      <input type="hidden" name="act" value="up">
      <input type="hidden" name="do" value="cartUpdate">
      <input type="hidden" name="id_product" value="{$product.id_product}">
      <input type="hidden" name="id_product_attribute" value="{$product.id_product_attribute}" [value]="attributes.id_product_attribute">
      <input type="hidden" name="price" value="{$product.price}" [value]="attributes.price">

      <div class="flex-container align-items-center atc-sect">
        <input type="text" name="qty" value="1" class="qty" [value]="product_quantity != null ? product_quantity : 1">
        <div class="flex-container flex-column align-items-center up-down-btns">
          <div class="btn" role="button" tabindex="0" on="tap:AMP.setState({ldelim}product_quantity: product_quantity != null ? product_quantity+1 : 2{rdelim})">+</div>
          <div class="btn" role="button" tabindex="0" on="tap:AMP.setState({ldelim}product_quantity: product_quantity > 1 ? product_quantity-1 : 1{rdelim})">-</div>
        </div>
        <button type="submit" class="add-to-cart big-btn">{l s='Add to cart' d='Shop.Theme.Amp'}</button>
      </div>
      <div submit-success class="flex-container align-items-center act-response">
        <amp-bodymovin-animation layout="flex-item" width="34" height="34" src="{$amp.global.assets}json/success.json" loop="false"></amp-bodymovin-animation><span>&nbsp;{l s='The product is in your cart now' d='Shop.Theme.Amp'}</span>
      </div>
      <div class="act-response" submitting>{l s='Waiting' d='Shop.Theme.Amp'}...</div>
      <div class="act-response" submit-error>{l s='Unable to Add to cart' d='Shop.Theme.Amp'}</div>

    </form>

    <amp-state id="product_quantity">
      <script type="application/json">{literal}{"1"}{/literal}</script>
    </amp-state>
    {/if}
    
    {if (isset($reassurance.elements))}
    <div id="block-reassurance" class="w-100">
      <ul>
        {foreach from=$reassurance.elements item=element}
        <li>
          <amp-img class="brimg" src="{$element.image}" alt="{$element.text|escape:'quotes'}" layout="fixed" width="30" height="30"></amp-img>
          <span>{$element.text}</span>
        </li>
        {/foreach}
      </ul>
    </div>
    {/if}

  </div>

  <amp-accordion disable-session-states class="flex-container flex-column ampstart-headerbar-nav product-details m80">
    {if $product.description}
    <section {if $product.description} expanded{/if}>
      <h4 role="tab" class="tabButton h4 ampstart-nav-item text-uppercase text-center">
        {l s='Description' d='Shop.Theme.Catalog'}
      </h4>
      <div role="tabpanel" class="tabContent p1 p">
        {$product.description nofilter}
      </div>
    </section>
    {/if}
    <section {if !$product.description} expanded{/if}>
      <h4 role="tab" class="tabButton h4 ampstart-nav-item text-uppercase text-center">
        {l s='Product Details' d='Shop.Theme.Catalog'}
      </h4>
      <div role="tabpanel" class="tabContent p1 p">
        {if isset($product_manufacturer->id)}
          <div class="product-manufacturer hidden">
            {if isset($manufacturer_image_url)}
              <a href="{$product_brand_url}">
                <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" />
              </a>
            {else}
              <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
              <span>
                <a href="{$product_brand_url}">{$product_manufacturer->name}</a>
              </span>
            {/if}
          </div>
        {/if}

        {if isset($product.reference_to_display)}
          <div class="product-reference hidden">
            <label class="label">{l s='Reference' d='Shop.Theme.Catalog'} </label>
            <span itemprop="sku">{$product.reference_to_display}</span>
          </div>
        {/if}

        {if isset($product.show_quantities) && $product.show_quantities}
        <div class="product-quantities hidden">
          <label class="label">{l s='In stock' d='Shop.Theme.Catalog'}</label>
          <span>{$product.quantity} {$product.quantity_label}</span>
        </div>
        {/if}

        {if $product.availability_date}
        <div class="product-availability-date">
          <label>{l s='Availability date:' d='Shop.Theme.Catalog'} </label>
          <span>{$product.availability_date}</span>
        </div>
        {/if}

        {if $product.features}
        <div class="product-features">
          <strong class="h6">{l s='Data sheet' d='Shop.Theme.Catalog'}</strong>
          <table>
          {foreach from=$product.features item=feature}
          <tr>
            <td class="name">{$feature.name}</td>
            <td class="value">{$feature.value}</td>
          </tr>
          {/foreach}
          </table>
        </div>
        {/if}

        {if isset($product.specific_references)}
        <div class="product-features">
          <strong class="h6">{l s='Specific References' d='Shop.Theme.Catalog'}</strong>
            <dl class="data-sheet">
              {foreach from=$product.specific_references item=reference key=key}
                <dt class="name">{$key}</dt>
                <dd class="value">{$reference}</dd>
              {/foreach}
            </dl>
        </div>
        {/if}

        {if $product.condition}
        <div class="product-condition">
          <label class="label">{l s='Condition' d='Shop.Theme.Catalog'}</label>
          <link itemprop="itemCondition" href="{$product.condition.schema_url}"/>
          <span>{$product.condition.label}</span>
        </div>
        {/if}
      </div>
    </section>
    {if $product.attachments}
    <section>
      <h4 role="tab" class="tabButton h4 ampstart-nav-item text-uppercase text-center">
        {l s='Attachments' d='Shop.Theme.Catalog'}
      </h4>
      <div role="tabpanel" class="tabContent p1 p">
        {if $product.attachments}
        <div class="tab-pane fade in" id="attachments">
           <section class="product-attachments">
             <strong class="h5 text-uppercase">{l s='Download' d='Shop.Theme.Actions'}</strong>
             {foreach from=$product.attachments item=attachment}
               <div class="attachment">
                 <h4><a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a></h4>
                 <p>{$attachment.description}</p>
                 <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                   {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
                 </a>
               </div>
             {/foreach}
           </section>
         </div>
        {/if}
      </div>
    </section>
    {/if}

    {foreach from=$customTabs item=tab}
      <section>
      <h4 role="tab" class="tabButton h4 ampstart-nav-item text-uppercase text-center">
        {$tab.name}
      </h4>
      <div role="tabpanel" class="tabContent p1 p">
        {$tab.default_content nofilter}
      </div>
    </section>
    {/foreach}
  
  </amp-accordion>

  {if (isset($amp.config.product.accessories) && ($amp.config.product.accessories == 1))}
  {if !empty($accessories)}
  <section class="product-accessories relative m30">
    <h4 class="module-title">
      <span>{l s='You might also like' d='Shop.Theme.Catalog'}</span>
    </h4>
    <amp-carousel {if (isset($amp.config.product.carousel.autoplay) && ($amp.config.product.carousel.autoplay == 1))}autoplay{/if} height="{$amp.global.images.home.size.height + 60}" layout="fixed-height" type="carousel">
      {foreach from=$accessories item=accessory}
        {include file="mobile/catalog/_partials/miniatures/product.tpl" product=$accessory image_size='home_default'}
      {/foreach}
    </amp-carousel>
  </section>
  {/if}
  {/if}

  {if (isset($amp.config.product.samecategory) && ($amp.config.product.samecategory == 1))}
  <div data-hook="displayFooterProduct">
  {hook h='displayFooterProduct' product=$product amp=1}
  </div>
  {/if}

</div>
{/block}