{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}

{block name='head_styles' append}
{literal}
.contact-page input, .contact-page textarea {
  width:100%;
  padding:10px 20px;
  line-height:20px;
  border:1px solid #e1e1e1;
  font-family:Arial;
  font-size:14px;
  color:#aaa;
  box-sizing: border-box
}
.contact-page select {
  width:100%;
  padding:10px 20px;
}
.contact-form .success-icon {max-width:34px}
{/literal}
{/block}

{block name='content'}
<section class="contact-form">
  <h2 class="page-title">{l s='Contact us' d='Modules.Contactform.Shop'}</h2>
  <div class="contact-page">
  {if (isset($page_error) && ($page_error == 1))}
    <div class="notification alert alert-error">
      {l s='Please make sure the module "Contact form" is installed and enabled' d='Shop.Theme.Amp'}
    </div>
  {else}

  <form method="post" action-xhr="{url entity='module' name='pk_amp' controller='ajaxContact' relative_protocol=false params=['who' => 'contact']}" target="_top" class="m30">

    <input type="hidden" name="url" value=""/>
    <input type="hidden" name="token" value="{$token}" />

    <div class="m15">
    <select name="id_contact">
      <option value="" disabled>{l s='Subject Heading' d='Modules.Contactform.Shop'}</option>
      {foreach from=$contact.contacts item=contact_elt name=contc}
        <option value="{$contact_elt.id_contact}"{if $smarty.foreach.contc.index == 0} selected{/if}>{$contact_elt.name}</option>
      {/foreach}
    </select>
    </div>

    {if $contact.orders}
    <div class="m15">
    <select name="id_order">
      <option value="">{l s='Select reference' d='Modules.Contactform.Shop'}</option>
      {foreach from=$contact.orders item=order}
        <option value="{$order.id_order}">{$order.reference}</option>
      {/foreach}
    </select>
    </div>
    {/if}

    <div class="m15">
    <input type="email" name="from" class="form-control" value="{$contact.email}" required placeholder="{l s='Email address' d='Modules.Contactform.Shop'}" />
    </div>

    <div class="m15">
    <textarea cols="67" rows="3" name="message" placeholder="{l s='Message' d='Modules.Contactform.Shop'}" required>{if $contact.message}{$contact.message}{/if}</textarea>
    </div>

    <div class="m15">
    {if isset($id_module)}
    {hook h='displayGDPRConsent' id_module=$id_module}
    {/if}
    </div>

    <button type="submit" class="btn btn-primary m15" name="submitMessage">
      {l s='Send Message' d='Modules.Contactform.Shop'}
    </button>

    <div submit-success class="p0">
      <template type="amp-mustache">
        <div class="flex-container align-items-center success-templ">
        <amp-bodymovin-animation class="success-icon" layout="flex-item" width="34" height="34" src="{$amp.global.assets}json/success.json" loop="false"></amp-bodymovin-animation><div>&nbsp;{literal}{{success}}{/literal}</div>
        </div>
      </template>
    </div>

    <div submit-error class="p0">
        {l s='Something goes wrong. Please try again later' d='Shop.Theme.Amp'}
    </div>
    <div submitting>{l s='Waiting' d='Shop.Theme.Amp'}...</div>
  </form>
  </div>
{/if}
</section>
{/block}