{*
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

{extends file='mobile/layouts/layout-main.tpl'}

{block name='content'}
<section class="identity">
  
  <h2 class="page-title">{l s='Identity' d='Shop.Theme.Amp'}</h2>

  {block name='page_content'}
    
    <form action-xhr="{url entity='module' name='pk_amp' controller='ajaxCustomer' relative_protocol=false params=['who' => 'identity']}" method="POST">
      <div class="form-item m15">
        <label class="radio-inline">
          <span>{l s='Mr.' d='Shop.Theme.Amp'}</span>
          <input name="id_gender" type="radio" value="1"{if isset($customer.gender.type) && $customer.gender.type == 0} checked{/if}>
        </label>
        <label class="radio-inline">
          <span>{l s='Mrs.' d='Shop.Theme.Amp'}</span>
          <input name="id_gender" type="radio" value="2"{if isset($customer.gender.type) && $customer.gender.type == 1} checked{/if}>
        </label>
      </div>
      <div class="form-item m15">
        <input class="form-control" name="firstname" type="text" value="{$customer.firstname}" required placeholder="{l s='First Name' d='Shop.Theme.Amp'}">
      </div>
      <div class="form-item m15">
        <input class="form-control" name="lastname" type="text" value="{$customer.lastname}" required placeholder="{l s='Last Name' d='Shop.Theme.Amp'}">
      </div>
      <div class="form-item m15">
          <input class="form-control" name="email" type="email" value="{$customer.email}" required placeholder="{l s='Email' d='Shop.Theme.Amp'}">
      </div>
      <div class="form-item m15">
        <input class="form-control" name="password" type="password" value="" pattern=".{literal}{5,}{/literal}" required placeholder="******">
      </div>
      <div class="form-item m15">
        <input class="form-control" name="new_password" type="password" value="" pattern=".{literal}{5,}{/literal}" placeholder="******">
      </div>
      <div class="form-item m15">
        <input class="form-control" name="birthday" type="text" value="{if ($customer.birthday != '0000-00-00')}{$customer.birthday}{/if}" placeholder="{l s='Birthday' d='Shop.Theme.Amp'}: YYYY-MM-DD">
      </div>
      <div class="form-item m15">
        <input name="optin" id="optin" type="checkbox" value="1"{if isset($customer.optin) && $customer.optin == 1} checked{/if}>
        <label for="optin">{l s='Receive offers from our partners' d='Shop.Theme.Amp'}</label>
      </div>
      <div class="form-item m15">
        <input name="newsletter" id="newsletter" type="checkbox" value="1"{if isset($customer.newsletter) && $customer.newsletter == 1} checked{/if}>
        <label for="newsletter">{l s='Sign up for our newsletter' d='Shop.Theme.Amp'}</label>
      </div>
      <div class="form-item">
        <input type="hidden" name="action" value="identity">
        <button class="btn" type="submit">{l s='Save' d='Shop.Theme.Amp'}</button>
      </div>

      <div submit-success>
        <div class="flex-container align-items-center vert-templ flex-column">
          <amp-bodymovin-animation layout="flex-item" width="40" height="40" src="{$amp.global.assets}json/success.json" loop="false"></amp-bodymovin-animation>
          <div>{l s='Personal information is changed' d='Shop.Theme.Amp'}</div>
        </div>
      </div>

      <div submit-error>
        <div class="flex-container align-items-center flex-column p20">
          <div>{l s='Something goes wrong. Please try again' d='Shop.Theme.Amp'}</div>
        </div>
      </div>
    </form>
    
  {/block}

</section>
{/block}